<?php $__env->startSection('title', trans('messages.blacklist')); ?>

<?php $__env->startSection('page_script'); ?>
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery_ui/interactions.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery_ui/touch.min.js')); ?>"></script>

    <script type="text/javascript" src="<?php echo e(URL::asset('js/listing.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_header'); ?>
    <div class="page-title">
        <ul class="breadcrumb breadcrumb-caret position-right">
            <li><a href="<?php echo e(action("HomeController@index")); ?>"><?php echo e(trans('messages.home')); ?></a></li>
        </ul>
        <h1>
            <span class="text-semibold"><i class="icon-list2"></i> <?php echo e(trans('messages.blacklist')); ?></span>
        </h1>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php if(is_object($system_job)): ?>
        <div class="alert alert-warning mb-30">
            <button data-dismiss="alert" class="close" type="button"><span>×</span><span class="sr-only">Close</span></button>
            <?php echo trans('messages.blacklist.an_import_job_is_running', [
                'link' => action('BlacklistController@import')
            ]); ?>

        </div>
    <?php endif; ?>

    <form class="listing-form"
        data-url="<?php echo e(action('BlacklistController@listing')); ?>"
        per-page="<?php echo e(Acelle\Model\Blacklist::$itemsPerPage); ?>"
    >

        <div class="row top-list-controls">
            <div class="col-md-9">
                <?php if($blacklists->count() >= 0): ?>
                    <div class="filter-box">
                        <?php echo $__env->make('helpers.select_tool', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                        <div class="btn-group list_actions hide">
                            <button type="button" class="btn btn-xs btn-grey-600 dropdown-toggle" data-toggle="dropdown">
                                <?php echo e(trans('messages.actions')); ?> <span class="caret"></span>
                            </button>
                            <ul class="dropdown-menu">
                                <li><a delete-confirm="<?php echo e(trans('messages.remove_blacklist_confirm')); ?>" href="<?php echo e(action('BlacklistController@delete')); ?>"><i class="icon-trash"></i> <?php echo e(trans('messages.delete')); ?></a></li>
                            </ul>
                        </div>
                        <span class="filter-group">
                            <span class="title text-semibold text-muted"><?php echo e(trans('messages.sort_by')); ?></span>
                            <select class="select" name="sort-order">
                                <option value="blacklists.created_at"><?php echo e(trans('messages.created_at')); ?></option>
                                <option value="blacklists.email"><?php echo e(trans('messages.email')); ?></option>
                            </select>
                            <button class="btn btn-xs sort-direction" rel="desc" data-popup="tooltip" title="<?php echo e(trans('messages.change_sort_direction')); ?>" type="button" class="btn btn-xs">
                                <i class="icon-sort-amount-desc"></i>
                            </button>
                        </span>
                        <span class="text-nowrap">
                            <input name="search_keyword" class="form-control search" placeholder="<?php echo e(trans('messages.type_to_search')); ?>" />
                            <i class="icon-search4 keyword_search_button"></i>
                        </span>
                    </div>
                <?php endif; ?>
            </div>
            <div class="col-md-3">
                <?php if(Auth::user()->customer->can('import', new Acelle\Model\Blacklist())): ?>
                    <div class="text-right">
                        <a href="<?php echo e(action('BlacklistController@import')); ?>" type="button" class="btn bg-info-800">
                            <i class="icon-download4"></i> <?php echo e(trans('messages.blacklist.import')); ?>

                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="pml-table-container">
        </div>
    </form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>