<?php $__env->startSection('title', trans('messages.campaigns') . " - " . trans('messages.setup')); ?>
	
<?php $__env->startSection('page_script'); ?>
	<script type="text/javascript" src="<?php echo e(URL::asset('assets/js/plugins/forms/styling/uniform.min.js')); ?>"></script>
		
    <script type="text/javascript" src="<?php echo e(URL::asset('js/validate.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_header'); ?>
	
			<div class="page-title">
				<ul class="breadcrumb breadcrumb-caret position-right">
					<li><a href="<?php echo e(action("HomeController@index")); ?>"><?php echo e(trans('messages.home')); ?></a></li>
					<li><a href="<?php echo e(action("CampaignController@index")); ?>"><?php echo e(trans('messages.campaigns')); ?></a></li>
				</ul>
				<h1>
					<span class="text-semibold"><i class="icon-paperplane"></i> <?php echo e($campaign->name); ?></span>
				</h1>

				<?php echo $__env->make('campaigns._steps', ['current' => 2], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
			</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
                <form action="<?php echo e(action('CampaignController@setup', $campaign->uid)); ?>" method="POST" class="form-validate-jqueryz">
					<?php echo e(csrf_field()); ?>

					
					<div class="row">
						<div class="col-md-6 list_select_box" target-box="segments-select-box" segments-url="<?php echo e(action('SegmentController@selectBox')); ?>">
							<?php echo $__env->make('helpers.form_control', ['type' => 'text',
                                                                'name' => 'name',
                                                                'label' => trans('messages.name_your_campaign'),
                                                                'value' => $campaign->name,
                                                                'rules' => $rules,
                                                                'help_class' => 'campaign'
                                                            ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                                                            
                            <?php echo $__env->make('helpers.form_control', ['type' => 'text',
                                                                'name' => 'subject',
                                                                'label' => trans('messages.email_subject'),
                                                                'value' => $campaign->subject,
                                                                'rules' => $rules,
                                                                'help_class' => 'campaign'
                                                            ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                                                            
                            <?php echo $__env->make('helpers.form_control', ['type' => 'text',
                                                                'name' => 'from_name',
                                                                'label' => trans('messages.from_name'),
                                                                'value' => $campaign->from_name,
                                                                'rules' => $rules,
                                                                'help_class' => 'campaign'
                                                            ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                            
                            <?php echo $__env->make('helpers.form_control', ['type' => 'text',
                                                                'name' => 'from_email',
                                                                'label' => trans('messages.from_email'),
                                                                'value' => $campaign->from_email,
                                                                'rules' => $rules,
                                                                'help_class' => 'campaign'
                                                            ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                                                            
                            <?php echo $__env->make('helpers.form_control', ['type' => 'text',
                                                                'name' => 'reply_to',
                                                                'label' => trans('messages.reply_to'),
                                                                'value' => $campaign->reply_to,
                                                                'rules' => $rules,
                                                                'help_class' => 'campaign'
                                                            ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
						</div>
						<div class="col-md-6 segments-select-box">
                            <div class="form-group checkbox-right-switch">
                                <?php echo $__env->make('helpers.form_control', ['type' => 'checkbox',
                                                                'name' => 'track_open',
                                                                'label' => trans('messages.track_opens'),
                                                                'value' => $campaign->track_open,
                                                                'options' => [false,true],
                                                                'help_class' => 'campaign',
                                                                'rules' => $rules
                                                            ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                                
                                <?php echo $__env->make('helpers.form_control', ['type' => 'checkbox',
                                                                'name' => 'track_click',
                                                                'label' => trans('messages.track_clicks'),
                                                                'value' => $campaign->track_click,
                                                                'options' => [false,true],
                                                                'help_class' => 'campaign',
                                                                'rules' => $rules
                                                            ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                                
                                <?php echo $__env->make('helpers.form_control', ['type' => 'checkbox',
                                                                'name' => 'sign_dkim',
                                                                'label' => trans('messages.sign_dkim'),
                                                                'value' => $campaign->sign_dkim,
                                                                'options' => [false,true],
                                                                'help_class' => 'campaign',
                                                                'rules' => $rules
                                                            ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                            </div>
						</div>
					</div>
					<hr>
					<div class="text-right">
						<button class="btn bg-teal-800"><?php echo e(trans('messages.next')); ?> <i class="icon-arrow-right7"></i> </button>
					</div>
					
				<form>
					
				
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>