                        <?php if($items->count() > 0): ?>
							<table class="table table-box pml-table"
                                current-page="<?php echo e(empty(request()->page) ? 1 : empty(request()->page)); ?>"
                            >
								<?php foreach($items as $key => $item): ?>
									<tr>
										<td width="1%">
											<div class="text-nowrap">
												<div class="checkbox inline">
													<label>
														<input type="checkbox" class="node styled"
															custom-order="<?php echo e($item->custom_order); ?>"
															name="ids[]"
															value="<?php echo e($item->uid); ?>"
														/>
													</label>
												</div>
											</div>
										</td>
										<td>
											<span class="server-avatar server-avatar-<?php echo e($item->type); ?> mr-0">
												<i class="icon-server"></i>
											</span>
										</td>
										<td>
											<h5 class="no-margin text-bold">
												<a class="kq_search" href="<?php echo e(action('Admin\SendingServerController@edit', ["uid" => $item->uid, "type" => $item->type])); ?>"><?php echo e($item->name); ?></a>
											</h5>
											<span class="text-muted">
												<?php echo is_object($item->admin) ? '<i class="icon-user-tie"></i>' . $item->admin->displayName() : ''; ?>

												<?php echo is_object($item->customer) ? '<i class="icon-user"></i>' . $item->customer->displayName() : ''; ?>

											</span>
											<br />
											<span class="text-muted"><?php echo e(trans('messages.created_at')); ?>: <?php echo e(Tool::formatDateTime($item->created_at)); ?></span>
										</td>
										<td>
											<div class="single-stat-box pull-left ml-20">
												<span class="no-margin stat-num kq_search"><?php echo e(trans('messages.' . $item->type)); ?></span>
												<br />
												<span class="text-muted"><?php echo e(trans('messages.type')); ?></span>
											</div>
										</td>
										<td>
											<?php if(!empty($item->host)): ?>
												<div class="single-stat-box pull-left ml-20">
													<span title="<?php echo e($item->host); ?>" class="no-margin stat-num kq_search domain-truncate"><?php echo e($item->host); ?></span>
													<br />
													<span class="text-muted"><?php echo e(trans('messages.host')); ?></span>
												</div>
											<?php elseif(!empty($item->aws_region)): ?>
												<div class="single-stat-box pull-left ml-20">
													<span title="<?php echo e($item->aws_region); ?>" class="no-margin stat-num kq_search domain-truncate"><?php echo e($item->aws_region); ?></span>
													<br />
													<span class="text-muted"><?php echo e(trans('messages.aws_region')); ?></span>
												</div>
											<?php elseif(!empty($item->domain)): ?>
												<div class="single-stat-box pull-left ml-20">
													<span title="<?php echo e($item->domain); ?>" class="no-margin stat-num kq_search domain-truncate"><?php echo e($item->domain); ?></span>
													<br />
													<span class="text-muted"><?php echo e(trans('messages.domain')); ?></span>
												</div>
											<?php endif; ?>
										</td>
										<td>
											<div class="single-stat-box pull-left ml-20">
												<span class="text-muted"><strong><?php echo e(number_with_delimiter($item->getSendingQuotaUsage())); ?></strong> <?php echo e(trans('messages.' . Acelle\Library\Tool::getPluralPrase('email', $item->getSendingQuotaUsage()) . '_quota')); ?></span>
												<br />
												<span class="text-muted2"><?php echo e(trans('messages.sending_server.speed', ['limit' => $item->displayQuota()])); ?></span>
											</div>
										</td>
										<td>
											<span class="text-muted2 list-status pull-left">
												<span class="label label-flat bg-<?php echo e($item->status); ?>"><?php echo e(trans('messages.sending_server_status_' . $item->status)); ?></span>
											</span>
										</td>
										<td class="text-right text-nowrap">
											<?php if(Auth::user()->admin->can('update', $item)): ?>
												<a href="<?php echo e(action('Admin\SendingServerController@edit', ["uid" => $item->uid, "type" => $item->type])); ?>" data-popup="tooltip" title="<?php echo e(trans('messages.edit')); ?>" type="button" class="btn bg-grey btn-icon"><i class="icon-pencil"></i> <?php echo e(trans('messages.edit')); ?></a>
											<?php endif; ?>
											<?php if(Auth::user()->admin->can('delete', $item) || Auth::user()->admin->can('disable', $item) || Auth::user()->admin->can('enable', $item)): ?>
												<div class="btn-group">
													<button type="button" class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret ml-0"></span></button>
													<ul class="dropdown-menu dropdown-menu-right">
														<?php if(Auth::user()->admin->can('enable', $item)): ?>
															<li>
																<a link-confirm="<?php echo e(trans('messages.enable_sending_servers_confirm')); ?>" href="<?php echo e(action('Admin\SendingServerController@enable', ["uids" => $item->uid])); ?>">
																	<i class="icon-checkbox-checked2"></i> <?php echo e(trans('messages.enable')); ?>

																</a>
															</li>
														<?php endif; ?>
														<?php if(Auth::user()->admin->can('disable', $item)): ?>
															<li>
																<a link-confirm="<?php echo e(trans('messages.disable_sending_servers_confirm')); ?>" href="<?php echo e(action('Admin\SendingServerController@disable', ["uids" => $item->uid])); ?>">
																	<i class="icon-checkbox-unchecked2"></i> <?php echo e(trans('messages.disable')); ?>

																</a>
															</li>
														<?php endif; ?>
														<?php if(Auth::user()->admin->can('delete', $item)): ?>
															<li>
																<a delete-confirm="<?php echo e(trans('messages.delete_sending_servers_confirm')); ?>" href="<?php echo e(action('Admin\SendingServerController@delete', ["uids" => $item->uid])); ?>">
																	<i class="icon-trash"></i> <?php echo e(trans('messages.delete')); ?>

																</a>
															</li>
														<?php endif; ?>
													</ul>
												</div>
											<?php endif; ?>
										</td>
									</tr>
								<?php endforeach; ?>
							</table>
                            <?php echo $__env->make('elements/_per_page_select', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
							<?php echo e($items->links()); ?>

						<?php elseif(!empty(request()->keyword) || !empty(request()->filters["type"])): ?>
							<div class="empty-list">
								<i class="icon-server"></i>
								<span class="line-1">
									<?php echo e(trans('messages.no_search_result')); ?>

								</span>
							</div>
						<?php else: ?>
							<div class="empty-list">
								<i class="icon-server"></i>
								<span class="line-1">
									<?php echo e(trans('messages.sending_server_empty_line_1')); ?>

								</span>
							</div>
						<?php endif; ?>
