<?php $__env->startSection('title', trans('messages.dashboard')); ?>

<?php $__env->startSection('page_script'); ?>
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/plugins/visualization/echarts/echarts.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(URL::asset('js/chart.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <h1 class="mb-10"><?php echo e(trans('messages.frontend_dashboard_hello', ['name' => Auth::user()->customer->displayName()])); ?></h1>
    <p><?php echo e(trans('messages.frontend_dashboard_welcome')); ?></p>

    <h3 class="text-teal-800 mb-10 mt-40"><i class="icon-stats-bars4"></i> <?php echo e(trans("messages.used_quota")); ?></h3>
    <div class="row quota_box">
        <div class="col-sm-6 col-md-6">
            <div class="content-group-sm">
                <div class="pull-right text-teal-800 text-semibold">
                    <span class="text-muted"><?php echo e(\Acelle\Library\Tool::format_number(Auth::user()->customer->getSendingQuotaUsage())); ?>/<?php echo e((Auth::user()->customer->getSendingQuota() == -1) ? '∞' : \Acelle\Library\Tool::format_number(Auth::user()->customer->getSendingQuota())); ?></span>
                    &nbsp;&nbsp;&nbsp;<?php echo e(Auth::user()->customer->displaySendingQuotaUsage()); ?>

                </div>
                <h5 class="text-semibold mb-5"><?php echo e(trans('messages.sending_quota')); ?></h5>
                <div class="progress progress-xxs">
                    <div class="progress-bar bg-warning" style="width: <?php echo e(Auth::user()->customer->getSendingQuotaUsagePercentage()); ?>%">
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-md-6">
            <div class="content-group-sm">
                <div class="pull-right text-teal-800 text-semibold">
                    <span class="text-muted"><?php echo e(\Acelle\Library\Tool::format_number(Auth::user()->customer->listsCount())); ?>/<?php echo e(\Acelle\Library\Tool::format_number(Auth::user()->customer->maxLists())); ?></span>
                    &nbsp;&nbsp;&nbsp;<?php echo e(Auth::user()->customer->displayListsUsage()); ?>

                </div>
                <h5 class="text-semibold mb-5"><?php echo e(trans('messages.list')); ?></h5>
                <div class="progress progress-xxs">
                    <div class="progress-bar bg-warning" style="width: <?php echo e(Auth::user()->customer->listsUsage()); ?>%">
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-md-6">
            <div class="content-group-sm mt-20">
                <div class="pull-right text-teal-800 text-semibold">
                    <span class="text-muted progress-xxs"><?php echo e(\Acelle\Library\Tool::format_number(Auth::user()->customer->campaignsCount())); ?>/<?php echo e(\Acelle\Library\Tool::format_number(Auth::user()->customer->maxCampaigns())); ?></span>
                    &nbsp;&nbsp;&nbsp;<?php echo e(Auth::user()->customer->displayCampaignsUsage()); ?>

                </div>
                <h5 class="text-semibold mb-5 mt-0"><?php echo e(trans('messages.campaign')); ?></h5>
                <div class="progress progress-xxs">
                    <div class="progress-bar bg-warning" style="width: <?php echo e(Auth::user()->customer->campaignsUsage()); ?>%">
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-md-6">
            <div class="content-group-sm">
                <div class="pull-right text-teal-800 text-semibold">
                    <span class="text-muted"><?php echo e(\Acelle\Library\Tool::format_number(Auth::user()->customer->readCache('SubscriberCount', 0))); ?>/<?php echo e(\Acelle\Library\Tool::format_number(Auth::user()->customer->maxSubscribers())); ?></span>
                    &nbsp;&nbsp;&nbsp;<?php echo e(Auth::user()->customer->displaySubscribersUsage()); ?>

                </div>
                <h5 class="text-semibold mb-5"><?php echo e(trans('messages.subscriber')); ?></h5>
                <div class="progress progress-xxs">
                    <div class="progress-bar bg-warning" style="width: <?php echo e(Auth::user()->customer->readCache('SubscriberUsage', 0)); ?>%">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <h3 class="text-teal-800 mt-40"><i class="icon-paperplane"></i> <?php echo e(trans('messages.recently_sent_campaigns')); ?></h3>

    <?php if(Auth::user()->customer->sentCampaigns()->count() == 0): ?>
        <div class="empty-list">
            <i class="icon-paperplane"></i>
            <span class="line-1">
                <?php echo e(trans('messages.no_sent_campaigns')); ?>

            </span>
        </div>
    <?php else: ?>
        <div class="row">
            <div class="col-md-6">
                <?php echo $__env->make('helpers.form_control', [
                    'type' => 'select',
                    'class' => 'dashboard-campaign-select',
                    'name' => 'campaign_id',
                    'label' => '',
                    'value' => '',
                    'options' => Acelle\Model\Campaign::getSelectOptions(Auth::user()->customer, "done"),
                ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            </div>
        </div>
        <div class="campaign-quickview-container" data-url="<?php echo e(action("CampaignController@quickView")); ?>"></div>
    <?php endif; ?>

    <h3 class="text-teal-800 mt-40"><i class="icon-address-book2"></i> <?php echo e(trans('messages.list_growth')); ?></h3>

    <?php if(Auth::user()->customer->lists()->count() == 0): ?>
        <div class="empty-list">
            <i class="icon-address-book2"></i>
            <span class="line-1">
                <?php echo e(trans('messages.no_saved_lists')); ?>

            </span>
        </div>
    <?php else: ?>
        <div class="row">
            <div class="col-md-6">
                <?php echo $__env->make('helpers.form_control', [
                    'type' => 'select',
                    'class' => 'dashboard-list-select',
                    'name' => 'list_id',
                    'label' => '',
                    'value' => '',
                    'include_blank' => trans('messages.all'),
                    'options' => Auth::user()->customer->readCache('MailListSelectOptions', []),
                ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            </div>
        </div>
        <div class="list-quickview-container" data-url="<?php echo e(action("MailListController@quickView")); ?>"></div>
    <?php endif; ?>

    <h3 class="text-teal-800 mt-40"><i class="icon-podium"></i> <?php echo e(trans('messages.top_5')); ?></h3>
    <div class="tabbable">
        <ul class="nav nav-tabs nav-tabs-top">
            <li class="active text-semibold"><a href="#top-tab1" data-toggle="tab">
                <i class="icon-folder-open3"></i> <?php echo e(trans('messages.campaign_opens')); ?></a></li>
            <li class="text-semibold"><a href="#top-tab2" data-toggle="tab">
                <i class="icon-pointer"></i> <?php echo e(trans('messages.campaign_clicks')); ?></a></li>
            <li class="text-semibold"><a href="#top-tab3" data-toggle="tab">
                <i class="icon-link"></i> <?php echo e(trans('messages.clicked_links')); ?></a></li>
        </ul>
        <div class="tab-content">
            <div class="tab-pane active" id="top-tab1">
                <ul class="modern-listing mt-0 top-border-none">
                    <?php $__empty_1 = true; foreach(Acelle\Model\Campaign::topOpens(5, Auth::user()->customer)->get() as $num => $item): $__empty_1 = false; ?>
                        <li>
                            <div class="row">
                                <div class="col-sm-5 col-md-5">
                                    <i class="number"><?php echo e($num+1); ?></i>
                                    <h6 class="mt-0 mb-0 text-semibold">
                                        <a href="<?php echo e(action('CampaignController@overview', $item->uid)); ?>">
                                            <?php echo e($item->name); ?>

                                        </a>
                                    </h6>
                                    <p>
                                        <?php echo $item->displayRecipients(); ?>

                                    </p>
                                </div>
                                <div class="col-sm-2 col-md-2 text-left">
                                    <h5 class="no-margin text-bold">
                                        <?php echo e($item->aggregate); ?>

                                    </h5>
                                    <span class="text-muted"><?php echo e(trans('messages.opens')); ?></span>
                                        <br /><br />
                                </div>
                                <div class="col-sm-2 col-md-2 text-left">
                                    <h5 class="no-margin text-bold">
                                        <?php echo e(number_with_delimiter($item->readCache('UniqOpenCount'))); ?>

                                    </h5>
                                    <span class="text-muted"><?php echo e(trans('messages.uniq_opens')); ?></span>
                                        <br /><br />
                                </div>
                                <div class="col-sm-2 col-md-2 text-left">
                                    <h5 class="no-margin text-bold">
                                        <?php echo e((null !== $item->lastOpen()) ? Acelle\Library\Tool::formatDateTime($item->lastOpen()->created_at) : ""); ?>

                                    </h5>
                                    <span class="text-muted"><?php echo e(trans('messages.last_open')); ?></span>
                                        <br /><br />
                                </div>
                            </div>

                        </li>
                    <?php endforeach; if ($__empty_1): ?>
                        <li class="empty-li">
                            <?php echo e(trans('messages.empty_record_message')); ?>

                        </li>
                    <?php endif; ?>
                </ul>
            </div>
            <div class="tab-pane" id="top-tab2">
                <ul class="modern-listing mt-0 top-border-none">
                    <?php $__empty_1 = true; foreach(Acelle\Model\Campaign::topClicks(5, Auth::user()->customer)->get() as $num => $item): $__empty_1 = false; ?>
                        <li>
                            <div class="row">
                                <div class="col-sm-5 col-md-5">
                                    <i class="number"><?php echo e($num+1); ?></i>
                                    <h6 class="mt-0 mb-0 text-semibold">
                                        <a href="<?php echo e(action('CampaignController@overview', $item->uid)); ?>">
                                            <?php echo e($item->name); ?>

                                        </a>
                                    </h6>
                                    <p>
                                        <?php echo $item->displayRecipients(); ?>

                                    </p>
                                </div>
                                <div class="col-sm-2 col-md-2 text-left">
                                    <h5 class="no-margin text-bold">
                                        <?php echo e($item->aggregate); ?>

                                    </h5>
                                    <span class="text-muted"><?php echo e(trans('messages.clicks')); ?></span>
                                        <br /><br />
                                </div>
                                <div class="col-sm-2 col-md-2 text-left">
                                    <h5 class="no-margin text-bold">
                                        <?php echo e($item->urlCount()); ?>

                                    </h5>
                                    <span class="text-muted"><?php echo e(trans('messages.urls')); ?></span>
                                        <br /><br />
                                </div>
                                <div class="col-sm-2 col-md-2 text-left">
                                    <h5 class="no-margin text-bold">
                                        <?php echo e((null !== $item->lastClick()) ? Acelle\Library\Tool::formatDateTime($item->lastClick()->created_at) : ""); ?>

                                    </h5>
                                    <span class="text-muted"><?php echo e(trans('messages.last_clicked')); ?></span>
                                        <br /><br />
                                </div>
                            </div>
                        </li>
                    <?php endforeach; if ($__empty_1): ?>
                        <li class="empty-li">
                            <?php echo e(trans('messages.empty_record_message')); ?>

                        </li>
                    <?php endif; ?>
                </ul>
            </div>
            <div class="tab-pane" id="top-tab3">
                <ul class="modern-listing mt-0 top-border-none">
                    <?php $__empty_1 = true; foreach(Acelle\Model\Campaign::topLinks(5, Auth::user()->customer)->get() as $num => $item): $__empty_1 = false; ?>
                        <li>
                            <div class="row">
                                <div class="col-sm-6 col-md-6">
                                    <i class="number"><?php echo e($num+1); ?></i>
                                    <h6 class="mt-0 mb-0 text-semibold url-truncate">
                                        <a title="<?php echo e($item->url); ?>" href="<?php echo e($item->url); ?>" target="_blank">
                                            <?php echo e($item->url); ?>

                                        </a>
                                    </h6>
                                    <p>
                                        <?php echo e($item->campaigns()->count()); ?> <?php echo e(trans('messages.campaigns')); ?>

                                    </p>
                                </div>
                                <div class="col-sm-2 col-md-2 text-left">
                                    <h5 class="no-margin text-bold">
                                        <?php echo e($item->aggregate); ?>

                                    </h5>
                                    <span class="text-muted"><?php echo e(trans('messages.clicks')); ?></span>
                                        <br /><br />
                                </div>
                                <div class="col-sm-2 col-md-2 text-left">
                                    <h5 class="no-margin text-bold">
                                        <?php echo e((null !== $item->lastClick(Auth::user()->customer)) ? Acelle\Library\Tool::formatDateTime($item->lastClick(Auth::user()->customer)->created_at) : ""); ?>

                                    </h5>
                                    <span class="text-muted"><?php echo e(trans('messages.last_clicked')); ?></span>
                                    <br /><br />
                                </div>
                            </div>
                        </li>
                    <?php endforeach; if ($__empty_1): ?>
                        <li class="empty-li">
                            <?php echo e(trans('messages.empty_record_message')); ?>

                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </div>

    <h3 class="text-teal-800 mt-40"><i class="icon-history"></i> <?php echo e(trans('messages.activity_log')); ?></h3>

    <?php if(Auth::user()->customer->logs()->count() == 0): ?>
        <div class="empty-list">
            <i class="icon-history"></i>
            <span class="line-1">
                <?php echo e(trans('messages.no_activity_logs')); ?>

            </span>
        </div>
    <?php else: ?>
        <div class="scrollbar-box action-log-box">
            <!-- Timeline -->
            <div class="timeline timeline-left content-group">
                <div class="timeline-container">
                        <?php foreach(Auth::user()->customer->logs()->take(20)->get() as $log): ?>
                            <!-- Sales stats -->
                            <div class="timeline-row">
                                <div class="timeline-icon">
                                    <a href="#"><img src="<?php echo e(action('CustomerController@avatar', $log->customer->uid)); ?>" alt=""></a>
                                </div>

                                <div class="panel panel-flat timeline-content">
                                    <div class="panel-heading">
                                        <h6 class="panel-title text-semibold"><?php echo e($log->customer->displayName()); ?></h6>
                                        <div class="heading-elements">
                                            <span class="heading-text"><i class="icon-history position-left text-success"></i> <?php echo e(Tool::dateTime($log->created_at)->diffForHumans()); ?></span>
                                        </div>
                                    </div>

                                    <div class="panel-body">
                                        <?php echo $log->message(); ?>

                                    </div>
                                </div>
                            </div>
                            <!-- /sales stats -->
                        <?php endforeach; ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <br>
    <br>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>