<?php $__env->startSection('title', trans('messages.email_verification_servers')); ?>

<?php $__env->startSection('page_script'); ?>
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery_ui/interactions.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery_ui/touch.min.js')); ?>"></script>

    <script type="text/javascript" src="<?php echo e(URL::asset('js/listing.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_header'); ?>

	<div class="page-title">
		<ul class="breadcrumb breadcrumb-caret position-right">
			<li><a href="<?php echo e(action("Admin\HomeController@index")); ?>"><?php echo e(trans('messages.home')); ?></a></li>
		</ul>
		<h1>
			<span class="text-semibold"><i class="icon-list2"></i> <?php echo e(trans('messages.email_verification_servers')); ?></span>
		</h1>
	</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
	<p><?php echo e(trans('messages.email_verification_server.wording')); ?></p>

	<form class="listing-form"
		sort-url="<?php echo e(action('Admin\EmailVerificationServerController@sort')); ?>"
		data-url="<?php echo e(action('Admin\EmailVerificationServerController@listing')); ?>"
		per-page="<?php echo e(Acelle\Model\EmailVerificationServer::$itemsPerPage); ?>"
	>
		<div class="row top-list-controls">
			<div class="col-md-10">
				<?php if($servers->count() >= 0): ?>
					<div class="filter-box">
						<div class="btn-group list_actions hide">
							<button type="button" class="btn btn-xs btn-grey-600 dropdown-toggle" data-toggle="dropdown">
								<?php echo e(trans('messages.actions')); ?> <span class="caret"></span>
							</button>
							<ul class="dropdown-menu">
								<li><a link-confirm="<?php echo e(trans('messages.enable_email_verification_servers_confirm')); ?>" href="<?php echo e(action('Admin\EmailVerificationServerController@enable')); ?>"><i class="icon-checkbox-checked2"></i> <?php echo e(trans('messages.enable')); ?></a></li>
								<li><a link-confirm="<?php echo e(trans('messages.disable_email_verification_servers_confirm')); ?>" href="<?php echo e(action('Admin\EmailVerificationServerController@disable')); ?>"><i class="icon-checkbox-unchecked2"></i> <?php echo e(trans('messages.disable')); ?></a></li>
								<li><a delete-confirm="<?php echo e(trans('messages.delete_email_verification_servers_confirm')); ?>" href="<?php echo e(action('Admin\EmailVerificationServerController@delete')); ?>"><i class="icon-trash"></i> <?php echo e(trans('messages.delete')); ?></a></li>
							</ul>
						</div>
						<div class="checkbox inline check_all_list">
							<label>
								<input type="checkbox" class="styled check_all">
							</label>
						</div>
						<span class="filter-group">
							<span class="title text-semibold text-muted"><?php echo e(trans('messages.sort_by')); ?></span>
							<select class="select" name="sort-order">
								<option value="email_verification_servers.name"><?php echo e(trans('messages.name')); ?></option>
								<option value="email_verification_servers.created_at"><?php echo e(trans('messages.created_at')); ?></option>
								<option value="email_verification_servers.updated_at"><?php echo e(trans('messages.updated_at')); ?></option>
							</select>
							<button class="btn btn-xs sort-direction" rel="asc" data-popup="tooltip" title="<?php echo e(trans('messages.change_sort_direction')); ?>" type="button" class="btn btn-xs">
								<i class="icon-sort-amount-asc"></i>
							</button>
						</span>
						<span class="filter-group">
							<span class="title text-semibold text-muted"><?php echo e(trans('messages.type')); ?></span>
							<select class="select" name="type">
								<option value=""><?php echo e(trans('messages.all')); ?></option>
								<?php foreach(Acelle\Model\EmailVerificationServer::typeSelectOptions() as $service): ?>
									<option value="<?php echo e($service['value']); ?>"><?php echo e($service['text']); ?></option>
								<?php endforeach; ?>
							</select>
						</span>
						<span class="text-nowrap">
							<input name="search_keyword" class="form-control search" placeholder="<?php echo e(trans('messages.type_to_search')); ?>" />
							<i class="icon-search4 keyword_search_button"></i>
						</span>
					</div>
				<?php endif; ?>
			</div>
			<?php if(Auth::user()->admin->can('create', new Acelle\Model\EmailVerificationServer())): ?>
				<div class="col-md-2 text-right">
					<a href="<?php echo e(action("Admin\EmailVerificationServerController@create")); ?>" type="button" class="btn bg-info-800">
						<i class="icon icon-plus2"></i> <?php echo e(trans('messages.create_email_verification_server')); ?>

					</a>
				</div>
			<?php endif; ?>
		</div>

		<div class="pml-table-container">
		</div>
	</form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>