<?php $__env->startSection('title', trans('messages.update_subscription')); ?>

<?php $__env->startSection('page_script'); ?>
	<script type="text/javascript" src="<?php echo e(URL::asset('assets/js/plugins/forms/styling/uniform.min.js')); ?>"></script>

    <script type="text/javascript" src="<?php echo e(URL::asset('js/validate.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_header'); ?>

			<div class="page-title">
				<ul class="breadcrumb breadcrumb-caret position-right">
					<li><a href="<?php echo e(action("HomeController@index")); ?>"><?php echo e(trans('messages.home')); ?></a></li>
					<li><a href="<?php echo e(action("Admin\SubscriptionController@index")); ?>"><?php echo e(trans('messages.subscriptions')); ?></a></li>
					<li class="active"><?php echo e(trans('messages.update')); ?></li>
				</ul>
				<h1>
					<span class="text-semibold"><i class="icon-profile"></i> <?php echo e($subscription->customer->displayName()); ?>: <?php echo e($subscription->plan_name); ?></span>
				</h1>
			</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

	<form enctype="multipart/form-data" action="<?php echo e(action('Admin\SubscriptionController@update', $subscription->uid)); ?>" method="POST" class="subscription-form">
		<?php echo e(csrf_field()); ?>

		<input type="hidden" name="_method" value="PATCH">

		<div class="row">
			<div class="col-md-12">
                <?php if(!$subscription->isTimeUnlimited()): ?>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="">
                                <?php echo $__env->make('helpers.form_control', [
                                    'type' => 'date',
                                    'name' => 'start_at',
                                    'label' => trans('messages.start_at'),
                                    'value' => $subscription->start_at ? \Acelle\Library\Tool::dateTime($subscription->start_at)->format('Y-m-d') : '',
                                    'help_class' => 'subscription',
                                    'rules' => $subscription->rules(),
                                    'placeholder' => trans('messages.start_at')
                                ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="">
                                <?php echo $__env->make('helpers.form_control', [
                                    'type' => 'date',
                                    'name' => 'end_at',
                                    'label' => trans('messages.end_at'),
                                    'value' => $subscription->end_at ? \Acelle\Library\Tool::dateTime($subscription->end_at)->format('Y-m-d') : '',
                                    'help_class' => 'subscription',
                                    'rules' => $subscription->rules(),
                                    'placeholder' => trans('messages.end_at')
                                ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

				<?php echo $__env->make('admin.subscriptions._options', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
			</div>
			<!--<div class="col-md-3 text-center">
				<?php echo $__env->make('subscriptions._subscription', ['readonly' => true], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
			</div>-->
		</div>



		<hr />
		<div class="text-left">
			<button type='submit' class="btn bg-teal"><i class="icon-check"></i> <?php echo e(trans('messages.save')); ?></button>
		</div>
	</form>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>