<?php $__env->startSection('title', trans('messages.subscriptions')); ?>

<?php $__env->startSection('page_script'); ?>
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/plugins/forms/styling/uniform.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(URL::asset('js/validate.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_header'); ?>

    <div class="page-title">
        <ul class="breadcrumb breadcrumb-caret position-right">
            <li><a href="<?php echo e(action("HomeController@index")); ?>"><?php echo e(trans('messages.home')); ?></a></li>
            <li class="active"><?php echo e(trans('messages.api_token')); ?></li>
        </ul>
        <h1>
            <span class="text-semibold"><i class="icon-profile"></i> <?php echo e(Auth::user()->customer->displayName()); ?></span>
        </h1>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make("account._menu", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <div class="row">
        <div class="col-sm-12 col-md-6 col-lg-6">
            <h2 class="text-semibold"><?php echo e(trans('messages.subscription')); ?></h2>

            <div class="sub-section">
                <h3 class="text-semibold"><?php echo e(trans('messages.subscribe_to_a_plan')); ?></h3>

                <p><?php echo trans('messages.subscribe_to_a_plan_intro'); ?></p>

                <form enctype="multipart/form-data" action="<?php echo e(action('SubscriptionController@store')); ?>" method="POST" class="form-validate-jqueryz subscription-form">
                    <?php echo e(csrf_field()); ?>


                    <?php echo $__env->make('helpers.form_control', [
                        'type' => 'select_ajax',
                        'class' => 'subsciption-plan-select hook',
                        'name' => 'plan_uid',
                        'label' => trans('messages.select_plan'),
                        'selected' => [
                            'value' => is_object($subscription->plan) ? $subscription->plan->uid : '',
                            'text' => is_object($subscription->plan) ? $subscription->plan->name : ''
                        ],
                        'help_class' => 'subscription',
                        'rules' => $subscription->rules(),
                        'url' => action('PlanController@select2'),
                        'placeholder' => trans('messages.select_plan')
                    ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                    <div class="ajax-detail-box" data-url="<?php echo e(action('SubscriptionController@preview')); ?>" data-form=".subscription-form">
                        <?php echo $__env->make('subscriptions.preview', [
                            'subscription' => $subscription
                        ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>