<?php $__env->startSection('title', $list->name . ": " . trans('messages.create_subscriber')); ?>

<?php $__env->startSection('page_script'); ?>
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/plugins/forms/styling/uniform.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/plugins/pickers/anytime.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(URL::asset('js/validate.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_header'); ?>

    <?php echo $__env->make("lists._header", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make("lists._menu", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <div class="row">
        <div class="col-sm-12 col-md-6 col-lg-6">
            <div class="sub-section">
                <form enctype="multipart/form-data"  action="<?php echo e(action('SubscriberController@update', ['list_uid' => $list->uid, "uid" => $subscriber->uid])); ?>" method="POST" class="form-validate-jqueryz">
                    <?php echo e(csrf_field()); ?>

                    <input type="hidden" name="_method" value="PATCH">
                    <input type="hidden" name="list_uid" value="<?php echo e($list->uid); ?>" />
                    <?php echo $__env->make('helpers._upload',['src' => action('SubscriberController@avatar',  $subscriber->uid), 'dragId' => 'upload-avatar', 'preview' => 'image'], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                    <h3 class="clear-both"><?php echo e(trans("messages.basic_information")); ?></h3>
                    <?php echo $__env->make("subscribers._form", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

                    <button class="btn bg-teal mr-10"><i class="icon-check"></i> <?php echo e(trans('messages.save')); ?></button>
                    <a href="<?php echo e(action('SubscriberController@index', $list->uid)); ?>" class="btn bg-grey-800"><i class="icon-cross2"></i> <?php echo e(trans('messages.cancel')); ?></a>

                </form>
            </div>

            <div class="sub-section">
                <h3 class="text-semibold"><?php echo e(trans('messages.verification.title.email_verification')); ?></h3>

                <?php if(is_null($subscriber->emailVerification)): ?>
                    <p><?php echo trans('messages.verification.wording.verify', [ 'email' => sprintf("<strong>%s</strong>", $subscriber->email) ]); ?></p>
                    <form enctype="multipart/form-data" action="<?php echo e(action('SubscriberController@startVerification', ['uid' => $subscriber->uid])); ?>" method="POST" class="form-validate-jquery">
                        <?php echo e(csrf_field()); ?>


                        <input type="hidden" name="list_uid" value="<?php echo e($list->uid); ?>" />

                        <?php echo $__env->make('helpers.form_control', [
                            'type' => 'select',
                            'name' => 'email_verification_server_id',
                            'value' => '',
                            'options' => \Auth::user()->customer->emailVerificationServerSelectOptions(),
                            'help_class' => 'verification',
                            'rules' => ['email_verification_server_id' => 'required'],
                            'include_blank' => trans('messages.select_email_verification_server')
                        ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                        <div class="text-left">
                            <button class="btn bg-teal mr-10"> <?php echo e(trans('messages.verification.button.verify')); ?></button>
                        </div>
                    </form>
                <?php elseif($subscriber->emailVerification->isDeliverable()): ?>
                    <p><?php echo trans('messages.verification.wording.deliverable', [ 'email' => sprintf("<strong>%s</strong>", $subscriber->email), 'at' => sprintf("<strong>%s</strong>", $subscriber->emailVerification->created_at) ]); ?></p>
                    <form enctype="multipart/form-data" action="<?php echo e(action('SubscriberController@resetVerification', ['uid' => $subscriber->uid])); ?>" method="POST" class="form-validate-jquery">
                        <?php echo e(csrf_field()); ?>

                        <input type="hidden" name="list_uid" value="<?php echo e($list->uid); ?>" />

                        <div class="text-left">
                            <button class="btn bg-teal mr-10"><?php echo e(trans('messages.verification.button.reset')); ?></button>
                        </div>
                    </form>
                <?php elseif($subscriber->emailVerification->isUndeliverable()): ?>
                    <p><?php echo trans('messages.verification.wording.undeliverable', [ 'email' => sprintf("<strong>%s</strong>", $subscriber->email)]); ?></p>
                    <form enctype="multipart/form-data" action="<?php echo e(action('SubscriberController@resetVerification', ['uid' => $subscriber->uid])); ?>" method="POST" class="form-validate-jquery">
                        <input type="hidden" name="list_uid" value="<?php echo e($list->uid); ?>" />

                        <div class="text-left">
                            <button class="btn bg-teal mr-10"><?php echo e(trans('messages.verification.button.reset')); ?></button>
                        </div>
                    </form>
                <?php else: ?>
                    <p><?php echo trans('messages.verification.wording.risky_or_unknown', [ 'email' => sprintf("<strong>%s</strong>", $subscriber->email), 'at' => sprintf("<strong>%s</strong>", $subscriber->emailVerification->created_at), 'result' => sprintf("<strong>%s</strong>", $subscriber->emailVerification->result)]); ?></p>
                    <form enctype="multipart/form-data" action="<?php echo e(action('SubscriberController@resetVerification', ['uid' => $subscriber->uid])); ?>" method="POST" class="form-validate-jquery">
                        <input type="hidden" name="list_uid" value="<?php echo e($list->uid); ?>" />

                        <div class="text-left">
                            <button class="btn bg-teal mr-10"><?php echo e(trans('messages.verification.button.reset')); ?></button>
                        </div>
                    </form>
                <?php endif; ?>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>