<?php $__env->startSection('title', $campaign->name); ?>

<?php $__env->startSection('page_script'); ?>
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery_ui/interactions.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery_ui/touch.min.js')); ?>"></script>

    <script type="text/javascript" src="<?php echo e(URL::asset('js/listing.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_header'); ?>

			<?php echo $__env->make("campaigns._header", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

      <?php echo $__env->make("campaigns._menu", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

			<h2 class="text-semibold text-teal-800"><?php echo e(trans('messages.subscribers')); ?></h2>

			<form class="listing-form"
					data-url="<?php echo e(action('CampaignController@subscribersListing', $campaign->uid)); ?>"
					per-page="<?php echo e(Acelle\Model\Subscriber::$itemsPerPage); ?>"
				>
					<div class="row top-list-controls">
						<div class="col-md-12">
							<?php if($subscribers->count() >= 0): ?>
								<div class="filter-box">
									<?php echo $__env->make('helpers.select_tool', [
											'disable_all_items' => true
									], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
									<div class="btn-group list_actions hide mr-10">
										<button type="button" class="btn btn-xs btn-grey-600 dropdown-toggle" data-toggle="dropdown">
											<?php echo e(trans('messages.actions')); ?> <span class="caret"></span>
										</button>
										<ul class="dropdown-menu">
											<li>
												<a link-confirm="<?php echo e(trans('messages.subscribe_subscribers_confirm')); ?>" href="<?php echo e(action('SubscriberController@subscribe', $list->uid)); ?>">
													<i class="icon-enter"></i> <?php echo e(trans('messages.subscribe')); ?>

												</a>
											</li>
											<li>
												<a link-confirm="<?php echo e(trans('messages.unsubscribe_subscribers_confirm')); ?>" href="<?php echo e(action('SubscriberController@unsubscribe', $list->uid)); ?>">
													<i class="icon-exit"></i> <?php echo e(trans('messages.unsubscribe')); ?>

												</a>
											</li>
											<li>
												<a href="#" class="copy_move_subscriber"
													data-url="<?php echo e(action('SubscriberController@copyMoveForm', [
														'from_uid' => $list->uid,
														'action' => 'copy',
													])); ?>">
														<i class="icon-copy4"></i> <?php echo e(trans('messages.copy_to')); ?>

												</a>
											</li>
											<!--<li>
												<a href="#move" class="copy_move_subscriber"
													data-url="<?php echo e(action('SubscriberController@copyMoveForm', [
														'from_uid' => $list->uid,
														'action' => 'move',
													])); ?>">
													<i class="icon-move-right"></i> <?php echo e(trans('messages.move_to')); ?>

												</a>
											</li>-->
											<li>
												<a delete-confirm="<?php echo e(trans('messages.delete_subscribers_confirm')); ?>" href="<?php echo e(action('SubscriberController@delete', $list->uid)); ?>">
													<i class="icon-trash"></i> <?php echo e(trans('messages.delete')); ?>

												</a>
											</li>
										</ul>
									</div>
									<div class="btn-group list_columns ml-10">
										<button type="button" class="btn btn-xs btn-grey-600 dropdown-toggle" data-toggle="dropdown">
											<?php echo e(trans('messages.columns')); ?> <span class="caret"></span>
										</button>
										<ul class="dropdown-menu dropdown-menu-right">
											<?php foreach($list->getFields as $field): ?>
												<?php if($field->tag != "EMAIL"): ?>
													<li>
														<div class="checkbox">
															<label>
																<input <?php echo e(($field->required ? "checked='checked'" : "")); ?> type="checkbox" id="<?php echo e($field->tag); ?>" name="columns[]" value="<?php echo e($field->uid); ?>" class="styled">
																<?php echo e($field->label); ?>

															</label>
														</div>
													</li>
												<?php endif; ?>
											<?php endforeach; ?>
											<li>
												<div class="checkbox">
													<label>
														<input type="checkbox" id="created_at" name="columns[]" value="created_at" class="styled">
														<?php echo e(trans('messages.created_at')); ?>

													</label>
												</div>
											</li>
											<li>
												<div class="checkbox">
													<label>
														<input type="checkbox" id="updated_at" name="columns[]" value="updated_at" class="styled">
														<?php echo e(trans('messages.updated_at')); ?>

													</label>
												</div>
											</li>
										</ul>
									</div>
									<span class="filter-group ml-20">
										<span class="title text-semibold text-muted"><?php echo e(trans('messages.subscribers_who')); ?></span>
										<select class="select" name="open">
											<option value="">-- <?php echo e(trans('messages.open')); ?> --</option>
											<option value="opened"><?php echo e(trans('messages.opened')); ?></option>
											<option <?php echo e((request()->open == 'not_opened' ? "selected" : '')); ?> value="not_opened"><?php echo e(trans('messages.not_opened')); ?></option>
										</select>
										<!--<span class="small-select2">
											<select class="select" name="and_or">
												<option value="and"><?php echo e(trans('messages.and')); ?></option>
												<option value="or"><?php echo e(trans('messages.or')); ?></option>
											</select>
										</span>-->
										<select class="select" name="click">
											<option value="">-- <?php echo e(trans('messages.click')); ?> --</option>
											<option value="clicked"><?php echo e(trans('messages.clicked')); ?></option>
											<option value="not_clicked"><?php echo e(trans('messages.not_clicked')); ?></option>
										</select>
									</span>
									<span class="filter-group mr-20">
										<span class="title text-semibold text-muted"><?php echo e(trans('messages.tracking_status')); ?></span>
										<select class="select" name="tracking_status">
											<option value="">-- <?php echo e(trans('messages.all')); ?> --</option>
											<!--<option value="not_sent"><?php echo e(trans('messages.not_sent')); ?></option>-->
											<option value="error"><?php echo e(trans('messages.error')); ?></option>
											<option value="sent"><?php echo e(trans('messages.sent')); ?></option>
										</select>
									</span>
									<span class="text-nowrap">
										<input name="search_keyword" class="form-control search" placeholder="<?php echo e(trans('messages.type_to_search')); ?>" />
										<i class="icon-search4 keyword_search_button"></i>
									</span>
								</div>
							<?php endif; ?>
						</div>
					</div>

					<div class="pml-table-container">


					</div>
				</form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>