<?php if($campaigns->count() > 0): ?>
    <table class="table table-box pml-table"
        current-page="<?php echo e(empty(request()->page) ? 1 : empty(request()->page)); ?>"
    >
        <?php foreach($campaigns as $key => $campaign): ?>
            <tr>
                <td width="1%">
                    <div class="text-nowrap">
                        <div class="checkbox inline">
                            <label>
                                <input type="checkbox" class="node styled"
                                    custom-order="<?php echo e($campaign->custom_order); ?>"
                                    name="ids[]"
                                    value="<?php echo e($campaign->uid); ?>"
                                />
                            </label>
                        </div>
                        <?php if(request()->sort_order == 'custom_order' && empty(request()->keyword)): ?>
                            <i data-action="move" class="icon icon-more2 list-drag-button"></i>
                        <?php endif; ?>
                    </div>
                </td>
                <td width="1%">
                    <a href="#"  onclick="popupwindow('<?php echo e(action('CampaignController@preview', $campaign->uid)); ?>', '<?php echo e($campaign->name); ?>', 800, 800)">
                        <img class="template-thumb" width="100" height="120" src="<?php echo e(action('CampaignController@image', $campaign->uid)); ?>?v=<?php echo e(rand(0,10)); ?>" />
                    </a>
                </td>
                <td>
                    <h5 class="no-margin text-bold">
                        <a class="kq_search" href="<?php echo e(action('CampaignController@show', $campaign->uid)); ?>">
                            <?php echo e($campaign->name); ?>

                        </a>
                    </h5>
                    <span class="text-muted"><?php echo e(trans('messages.' . $campaign->type)); ?></span>

                    <br />
                    <?php if($campaign->status != 'new'): ?>
                        <span class="text-muted2"><?php echo e(trans('messages.run_at')); ?>: &nbsp;&nbsp;<i class="icon-alarm mr-0"></i> <?php echo e(isset($campaign->run_at) ? Tool::formatDateTime($campaign->run_at) : ""); ?></span>
                    <?php else: ?>
                        <span class="text-muted2"><?php echo e(trans('messages.updated_at')); ?>: <?php echo e(Tool::formatDateTime($campaign->created_at)); ?></span>
                    <?php endif; ?>
                </td>
                <td>
                    <div class="single-stat-box pull-left">
                        <span class="no-margin stat-num"><?php echo e(trans('messages.template_type_' . $campaign->template_source)); ?></span>
                        <br>
                        <span class="text-muted text-nowrap"><?php echo e(trans('messages.type')); ?></span>
                    </div>
                </td>
                <td class="text-right">
                    <a link-method="PATCH" href="<?php echo e(action('CampaignController@campaignTemplateChoose', ['uid' => $uid, 'from_uid' => $campaign->uid])); ?>" type="button" class="btn bg-teal btn-icon">
                        <i class="icon-checkmark4"></i> <?php echo e(trans('messages.choose')); ?>

                    </a>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>
    <?php echo $__env->make('elements/_per_page_select', ["items" => $campaigns], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php echo e($campaigns->links()); ?>

<?php elseif(!empty(request()->keyword)): ?>
    <div class="empty-list">
        <i class="icon-paperplane"></i>
        <span class="line-1">
            <?php echo e(trans('messages.no_search_result')); ?>

        </span>
    </div>
<?php else: ?>
    <div class="empty-list">
        <i class="icon-paperplane"></i>
        <span class="line-1">
            <?php echo e(trans('messages.campaign_empty_line_1')); ?>

        </span>
    </div>
<?php endif; ?>
