<?php if($blacklists->count() > 0): ?>
	<table class="table table-box pml-table table-log mt-10"
		current-page="<?php echo e(empty(request()->page) ? 1 : empty(request()->page)); ?>"
	>
		<tr>
			<th>
				<div class="checkbox inline check_all_list">
					<label>
						<input type="checkbox" class="styled check_all">
					</label>
				</div>
			</th>
			<th><?php echo e(trans('messages.email')); ?></th>
			<th><?php echo e(trans('messages.created_at')); ?></th>
			<th class="text-right"><?php echo e(trans('messages.action')); ?></th>
		</tr>
		<?php foreach($blacklists as $key => $blacklist): ?>
			<tr>
				<td width="1%">
					<div class="checkbox inline">
						<label>
							<input type="checkbox" class="node styled"
								name="ids[]"
								value="<?php echo e($blacklist->id); ?>"
							/>
						</label>
					</div>
				</td>
				<td>
					<span class="no-margin kq_search"><?php echo e($blacklist->email); ?></span>
					<span class="text-muted second-line-mobile"><?php echo e(trans('messages.email')); ?></span>
				</td>
				<td>
					<span class="no-margin kq_search"><?php echo e(Tool::formatDateTime($blacklist->created_at)); ?></span>
					<span class="text-muted second-line-mobile"><?php echo e(trans('messages.created_at')); ?></span>
				</td>
				<td class="text-right">
					<?php if(Auth::user()->customer->can('delete', $blacklist)): ?>
						<a
							delete-confirm="<?php echo e(trans('messages.remove_blacklist_confirm')); ?>"
							href="<?php echo e(action('BlacklistController@delete', ["uids" => $blacklist->id])); ?>"
							class="btn btn-primary btn-xs bg-grey"
							data-popup="tooltip" title="<?php echo e(trans('messages.remove_from_blacklist')); ?>"
						>
							<?php echo e(trans('messages.blacklist.remove')); ?>

						</a>
					<?php endif; ?>
				</td>
			</tr>
		<?php endforeach; ?>
	</table>
	<?php echo $__env->make('elements/_per_page_select', ["items" => $blacklists], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<?php echo e($blacklists->links()); ?>

<?php elseif(!empty(request()->keyword) || !empty(request()->filters["campaign_uid"])): ?>
	<div class="empty-list">
		<i class="glyphicon glyphicon-minus-sign"></i>
		<span class="line-1">
			<?php echo e(trans('messages.no_search_result')); ?>

		</span>
	</div>
<?php else: ?>
	<div class="empty-list">
		<i class="glyphicon glyphicon-minus-sign"></i>
		<span class="line-1">
			<?php echo e(trans('messages.blacklist_empty_line_1')); ?>

		</span>
	</div>
<?php endif; ?>
