<?php if($lists->count() > 0): ?>
	<table class="table table-box pml-table"
		current-page="<?php echo e(empty(request()->page) ? 1 : empty(request()->page)); ?>"
	>
		<?php foreach($lists as $key => $item): ?>
			<tr>
				<td width="1%">
					<div class="text-nowrap">
						<div class="checkbox inline">
							<label>
								<input type="checkbox" class="node styled"
									custom-order="<?php echo e($item->custom_order); ?>"
									name="ids[]"
									value="<?php echo e($item->uid); ?>"
								/>
							</label>
						</div>
						<?php if(request()->sort_order == 'custom_order' && empty(request()->keyword)): ?>
							<i data-action="move" class="icon icon-more2 list-drag-button"></i>
						<?php endif; ?>
					</div>
				</td>
				<td>
					<h5 class="no-margin text-bold">
						<a class="kq_search" href="<?php echo e(action('MailListController@overview', ['uid' => $item->uid])); ?>"><?php echo e($item->name); ?></a>
					</h5>
					<span class="text-muted"><?php echo e(trans('messages.created_at')); ?>: <?php echo e(Tool::formatDateTime($item->created_at)); ?></span>
					<?php if(empty($item->getSendingServers())): ?>
						<div class="text-danger"><i class="icon-alert"></i> <?php echo e(trans('messages.list_has_no_sending_server')); ?></div>
					<?php endif; ?>
				</td>
				<td class="stat-fix-size-sm">
					<div class="single-stat-box pull-left">
						<a href="<?php echo e(action('SubscriberController@index', $item->uid)); ?>">
							<span class="no-margin stat-num"><?php echo e(number_with_delimiter($item->readCache('SubscriberCount', 0))); ?></span>
						</a>
						<br />
						<span class="text-muted"><?php echo e(trans("messages." . Acelle\Library\Tool::getPluralPrase('subscriber', $item->readCache('SubscriberCount', 0)))); ?></span>
					</div>
					<div class="single-stat-box pull-left ml-20">
						<span class="no-margin text-teal-800 stat-num"><?php echo e($item->openUniqRate()); ?>%</span>
						<div class="progress progress-xxs">
							<div class="progress-bar progress-bar-info" style="width: <?php echo e($item->readCache('UniqOpenRate', 0)); ?>%">
							</div>
						</div>
						<span class="text-muted"><?php echo e(trans('messages.open_rate')); ?></span>
					</div>
					<div class="single-stat-box pull-left ml-20">
						<span class="no-margin text-teal-800 stat-num"><?php echo e($item->readCache('ClickedRate', 0)); ?>%</span>
						<div class="progress progress-xxs">
							<div class="progress-bar progress-bar-info" style="width: <?php echo e($item->readCache('ClickedRate', 0)); ?>%">
							</div>
						</div>
						<span class="text-muted"><?php echo e(trans('messages.click_rate')); ?></span>
					</div>
					<br style="clear:both" />
				</td>
				<td class="text-right">
					<a href="<?php echo e(action('SubscriberController@create', $item->uid)); ?>" data-popup="tooltip" title="<?php echo e(trans('messages.create_subscriber')); ?>" type="button" class="btn bg-grey-600 btn-icon"><i class="icon icon-plus2"></i><i class="glyphicon glyphicon-user"></i></a>
					<a href="<?php echo e(action('MailListController@overview', $item->uid)); ?>" data-popup="tooltip" title="<?php echo e(trans('messages.overview')); ?>" type="button" class="btn bg-teal-600 btn-icon"><i class="icon-stats-growth mr-0 pr-0"></i></a>
					<div class="btn-group">
						<button type="button" class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret ml-0"></span></button>
						<ul class="dropdown-menu dropdown-menu-right">
							<li><a href="<?php echo e(action('SubscriberController@index', $item->uid)); ?>"><i class="icon-users4"></i> <?php echo e(trans("messages.subscribers")); ?></a></li>
							<li><a href="<?php echo e(action('SegmentController@index', $item->uid)); ?>"><i class="icon-make-group"></i> <?php echo e(trans('messages.segments')); ?></a></li>
							<li>
								<a href="<?php echo e(action('MailListController@embeddedForm', $item->uid)); ?>">
									<i class="icon-embed2"></i> <?php echo e(trans('messages.Embedded_form')); ?>

								</a>
							</li>
							<li><a href="<?php echo e(action('PageController@update', ['list_uid' => $item->uid, 'alias' => 'sign_up_form'])); ?>"><i class="icon-certificate"></i> <?php echo e(trans('messages.custom_forms_and_emails')); ?></a></li>
							<li>
								<a class="level-1" href="<?php echo e(action('FieldController@index', $item->uid)); ?>">
									<i class="icon-list3"></i> <?php echo e(trans('messages.manage_list_fields')); ?>

								</a>
							</li>
							<li><a href="<?php echo e(action('MailListController@verification', $item->uid)); ?>"><i class="icon-envelop5"></i> <?php echo e(trans("messages.email_verification")); ?></a></li>
							<li><a href="<?php echo e(action('MailListController@edit', $item->uid)); ?>"><i class="icon-pencil7"></i> <?php echo e(trans("messages.edit_list")); ?></a></li>
							<?php if(\Auth::user()->can('import', $item)): ?>
								<li><a href="<?php echo e(action('SubscriberController@import', $item->uid)); ?>"><i class="icon-download4"></i> <?php echo e(trans('messages.import')); ?></a></li>
							<?php endif; ?>
							<?php if(\Auth::user()->can('export', $item)): ?>
								<li><a href="<?php echo e(action('SubscriberController@export', $item->uid)); ?>"><i class="icon-upload4"></i> <?php echo e(trans('messages.export')); ?></a></li>
							<?php endif; ?>
							<li>
								<a data-uid="<?php echo e($item->uid); ?>" data-name="<?php echo e(trans("messages.copy_of_list", ['name' => $item->name])); ?>" class="copy-list-link">
									<i class="icon-copy4"></i> <?php echo e(trans('messages.copy')); ?>

								</a>
							</li>
							<li>
								<a list-delete-confirm="<?php echo e(action('MailListController@deleteConfirm', ['uids' => $item->uid])); ?>" href="<?php echo e(action('MailListController@delete', ['uids' => $item->uid])); ?>">
									<i class="icon-trash"></i> <?php echo e(trans('messages.delete')); ?>

								</a>
							</li>
						</ul>
					</div>
				</td>
			</tr>
		<?php endforeach; ?>
	</table>
	<?php echo $__env->make('elements/_per_page_select', ["items" => $lists], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<?php echo e($lists->links()); ?>

<?php elseif(!empty(request()->keyword)): ?>
	<div class="empty-list">
		<i class="icon-address-book2"></i>
		<span class="line-1">
			<?php echo e(trans('messages.no_search_result')); ?>

		</span>
	</div>
<?php else: ?>
	<div class="empty-list">
		<i class="icon-address-book2"></i>
		<span class="line-1">
			<?php echo e(trans('messages.list_empty_line_1')); ?>

		</span>
		<span class="line-2">
			<?php echo e(trans('messages.list_empty_line_2')); ?>

		</span>
	</div>
<?php endif; ?>
