<?php if($customers->count() > 0): ?>
    <table class="table table-box pml-table"
        current-page="<?php echo e(empty(request()->page) ? 1 : empty(request()->page)); ?>"
    >
        <?php foreach($customers as $key => $item): ?>
            <tr>
                <td width="1%">
                    <img width="80" class="img-circle mr-10" src="<?php echo e(action('CustomerController@avatar', $item->uid)); ?>" alt="">
                </td>
                <td>
                    <h5 class="no-margin text-bold">
                        <a class="kq_search" href="<?php echo e(action('Admin\CustomerController@edit', $item->uid)); ?>"><?php echo e($item->displayName()); ?></a>
                    </h5>
                    <span class="text-muted kq_search"><?php echo e($item->user->email); ?></span>
                    <?php if (app('Illuminate\Contracts\Auth\Access\Gate')->check('readAll', $item)): ?>
                        <br />
                        <?php echo $__env->make('admin.modules.admin_line', ['admin' => $item->admin], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                    <?php endif; ?>
                    <br />
                    <span class="text-muted2"><?php echo e(trans('messages.created_at')); ?>: <?php echo e(Tool::formatDateTime($item->created_at)); ?></span>
                </td>
                <td>
                    <h5 class="no-margin">
                        <span><i class="icon-clipboard2"></i> <?php echo e($item->currentPlanName()); ?></span>
                    </h5>
                    <span class="text-muted2"><?php echo e(trans('messages.current_plan')); ?></span>
                </td>
                <td class="stat-fix-size">
                    <div class="single-stat-box pull-left ml-20">
                        <span class="no-margin text-teal-800 stat-num"><?php echo e($item->displaySendingQuotaUsage()); ?></span>
                        <div class="progress progress-xxs">
                            <div class="progress-bar progress-bar-info" style="width: <?php echo e($item->getSendingQuotaUsagePercentage()); ?>%">
                            </div>
                        </div>
                        <span class="text-muted"><strong><?php echo e(\Acelle\Library\Tool::format_number($item->getSendingQuotaUsage())); ?>/<?php echo e(($item->getSendingQuota() == -1) ? '∞' : \Acelle\Library\Tool::format_number($item->getSendingQuota())); ?></strong>
                            <div class="text-nowrap"><?php echo e(trans('messages.sending_credits_used')); ?></div>
                        </span>
                    </div>
                    <div class="single-stat-box pull-left ml-20">
                        <span class="no-margin text-teal-800 stat-num"><?php echo e($item->displaySubscribersUsage()); ?></span>
                        <div class="progress progress-xxs">
                            <div class="progress-bar progress-bar-info" style="width: <?php echo e($item->readCache('SubscriberUsage')); ?>%">
                            </div>
                        </div>
                        <span class="text-muted"><strong><?php echo e(number_with_delimiter($item->readCache('SubscriberCount'))); ?>/<?php echo e(number_with_delimiter($item->maxSubscribers())); ?></strong><br /> <?php echo e(trans('messages.subscribers')); ?></span>
                    </div>
                </td>
                <td>
                    <span class="text-muted2 list-status pull-left">
                        <span class="label label-flat bg-<?php echo e($item->status); ?>"><?php echo e(trans('messages.user_status_' . $item->status)); ?></span>
                    </span>
                </td>
                <td class="text-right">
                    <?php if (app('Illuminate\Contracts\Auth\Access\Gate')->check('loginAs', $item)): ?>
                        <a href="<?php echo e(action('Admin\CustomerController@loginAs', $item->uid)); ?>" data-popup="tooltip" title="<?php echo e(trans('messages.login_as_this_customer')); ?>" type="button" class="btn bg-teal-600 btn-icon"><i class="glyphicon glyphicon-random pr-5"></i></a>
                    <?php endif; ?>
                    <?php if (app('Illuminate\Contracts\Auth\Access\Gate')->check('update', $item)): ?>
                        <a href="<?php echo e(action('Admin\CustomerController@edit', $item->uid)); ?>" data-popup="tooltip" title="<?php echo e(trans('messages.edit')); ?>" type="button" class="btn bg-grey-600 btn-icon"><i class="icon icon-pencil pr-0 mr-0"></i></a>
                    <?php endif; ?>
                    <?php if(Auth::user()->can('delete', $item) || Auth::user()->can('enable', $item) || Auth::user()->can('disable', $item)): ?>
                        <div class="btn-group">
                            <button type="button" class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret ml-0"></span></button>
                            <ul class="dropdown-menu dropdown-menu-right">
                                <?php if (app('Illuminate\Contracts\Auth\Access\Gate')->check('enable', $item)): ?>
                                    <li>
                                        <a link-confirm="<?php echo e(trans('messages.enable_customers_confirm')); ?>" href="<?php echo e(action('Admin\CustomerController@enable', ["uids" => $item->uid])); ?>">
                                            <i class="icon-checkbox-checked2"></i> <?php echo e(trans('messages.enable')); ?>

                                        </a>
                                    </li>
                                <?php endif; ?>
                                <?php if (app('Illuminate\Contracts\Auth\Access\Gate')->check('disable', $item)): ?>
                                    <li>
                                        <a link-confirm="<?php echo e(trans('messages.disable_customers_confirm')); ?>" href="<?php echo e(action('Admin\CustomerController@disable', ["uids" => $item->uid])); ?>">
                                            <i class="icon-checkbox-unchecked2"></i> <?php echo e(trans('messages.disable')); ?>

                                        </a>
                                    </li>
                                <?php endif; ?>
                                <?php if (app('Illuminate\Contracts\Auth\Access\Gate')->check('read', $item)): ?>
                                    <li>
                                        <a href="<?php echo e(action('Admin\CustomerController@subscriptions', $item->uid)); ?>">
                                            <i class="icon-quill4"></i> <?php echo e(trans('messages.subscriptions')); ?>

                                        </a>
                                    </li>
                                <?php endif; ?>
                                <li>
                                    <a delete-confirm="<?php echo e(trans('messages.delete_users_confirm')); ?>" href="<?php echo e(action('Admin\CustomerController@delete', ['uids' => $item->uid])); ?>">
                                        <i class="icon-trash"></i> <?php echo e(trans('messages.delete')); ?>

                                    </a>
                                </li>
                            </ul>
                        </div>
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>
    <?php echo $__env->make('elements/_per_page_select', ["items" => $customers], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php echo e($customers->links()); ?>

<?php elseif(!empty(request()->keyword)): ?>
    <div class="empty-list">
        <i class="icon-users"></i>
        <span class="line-1">
            <?php echo e(trans('messages.no_search_result')); ?>

        </span>
    </div>
<?php else: ?>
    <div class="empty-list">
        <i class="icon-users"></i>
        <span class="line-1">
            <?php echo e(trans('messages.customer_empty_line_1')); ?>

        </span>
    </div>
<?php endif; ?>
