<?php if($subscriptions->count() > 0): ?>
	<table class="table table-box pml-table table-log"
		current-page="<?php echo e(empty(request()->page) ? 1 : empty(request()->page)); ?>"
	>
		<?php foreach($subscriptions as $key => $subscription): ?>
			<tr>
				<td width="1%">
					<img width="80" class="img-circle mr-10" src="<?php echo e(action('CustomerController@avatar', $subscription->customer->uid)); ?>" alt="">
				</td>
				<td>
					<h5 class="no-margin text-bold">
						<a class="kq_search" href="<?php echo e(action('Admin\SubscriptionController@edit', $subscription->uid)); ?>">
							<?php echo e($subscription->customer->displayName()); ?>

						</a>
					</h5>
					<span class="text-muted kq_search"><?php echo e($subscription->customer->user->email); ?></span>
					<br />
					<span><i class="icon-clipboard2"></i> <?php echo e($subscription->plan->name); ?></span>
					<?php if(Auth::user()->admin->can('readAll', $subscription)): ?>
						<br />
						<?php echo $__env->make('admin.modules.admin_line', ['admin' => $subscription->customer->admin], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
					<?php endif; ?>
				</td>
				<td>
					<h5 class="no-margin text-bold">
						<?php echo e(Acelle\Library\Tool::format_price($subscription->price, $subscription->currency_format)); ?>

					</h5>
					<span class="text-muted"><?php echo e(trans('messages.price')); ?></span>
				</td>
                <?php if(!$subscription->isTimeUnlimited()): ?>
                    <td>
                        <h5 class="no-margin text-bold">
                            <?php echo e(Acelle\Library\Tool::formatDate($subscription->start_at)); ?>

                        </h5>
                        <span class="text-muted"><?php echo e(trans('messages.start_at')); ?></span>
                    </td>
                    <td>
                        <h5 class="no-margin text-bold">
                            <?php echo e(Acelle\Library\Tool::formatDate($subscription->end_at)); ?>

                        </h5>
                        <span class="text-muted"><?php echo e(trans('messages.end_at')); ?></span>
                    </td>
                    <td>
                        <?php if($subscription->beingUsed()): ?>
                            <h5 class="no-margin text-bold">
                                <?php echo e($subscription->daysRemainCount()); ?>

                            </h5>
                            <span class="text-muted"><?php echo trans_choice('messages.days_remain', $subscription->daysRemainCount()); ?></span>
                        <?php else: ?>
                            <h5 class="no-margin text-bold">
                                --
                            </h5>
                            <span class="text-muted"><?php echo trans_choice('messages.days_remain', 0); ?></span>
                        <?php endif; ?>
                    </td>
                <?php else: ?>
                    <td></td>
                    <td></td>
                    <td></td>
                <?php endif; ?>
                <td>
					<span class="text-muted2 list-status pull-left">
						<span class="label label-flat bg-<?php echo e($subscription->getStatus()); ?>"><?php echo e(trans('messages.subscription_status_' . $subscription->getStatus())); ?></span>
					</span>
				</td>
				<td>
                    <?php if($subscription->paymentsCount()): ?>
                        <span class="text-muted2 list-status pull-left payments-button"
                            data-url="<?php echo e(action('Admin\SubscriptionController@payments', $subscription->uid)); ?>">
                            <span class="label label-sub label-flat bg-<?php echo e($subscription->getPaidStatus()); ?>">
                                <?php echo e(trans('messages.subscription_paid_status_' . $subscription->getPaidStatus())); ?>

                                <i class="icon-history"></i>
                            </span>
                        </span>
                    <?php else: ?>
                        <span class="text-muted2 list-status pull-left">
                            <span class="label label-sub label-flat bg-<?php echo e($subscription->getPaidStatus()); ?>">
                                <?php echo e(trans('messages.subscription_paid_status_' . $subscription->getPaidStatus())); ?>

                            </span>
                        </span>
                    <?php endif; ?>
				</td>
				<td class="text-right">
					<?php if(Auth::user()->admin->can('update', $subscription)): ?>
						<a href="<?php echo e(action('Admin\SubscriptionController@edit', $subscription->uid)); ?>" data-popup="tooltip" title="<?php echo e(trans('messages.edit')); ?>" type="button" class="btn bg-grey-600 btn-icon"><i class="icon icon-pencil pr-0 mr-0"></i></a>
					<?php endif; ?>
					<?php if(\Auth::user()->admin->can('delete', $subscription) || Auth::user()->admin->can('enable', $subscription) || Auth::user()->admin->can('disable', $subscription)): ?>
						<div class="btn-group">
							<button type="button" class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret ml-0"></span></button>
							<ul class="dropdown-menu dropdown-menu-right">
								<?php if(Auth::user()->admin->can('enable', $subscription)): ?>
									<li>
										<a data-method='PATCH' link-confirm="<?php echo e(trans('messages.enable_subscriptions_confirm')); ?>" href="<?php echo e(action('Admin\SubscriptionController@enable', ["uids" => $subscription->uid])); ?>">
											<i class="icon-checkbox-checked2"></i> <?php echo e(trans('messages.enable')); ?>

										</a>
									</li>
								<?php endif; ?>
								<?php if(Auth::user()->admin->can('disable', $subscription)): ?>
									<li>
										<a data-method='PATCH' link-confirm="<?php echo e(trans('messages.disable_subscriptions_confirm')); ?>" href="<?php echo e(action('Admin\SubscriptionController@disable', ["uids" => $subscription->uid])); ?>">
											<i class="icon-checkbox-unchecked2"></i> <?php echo e(trans('messages.disable')); ?>

										</a>
									</li>
								<?php endif; ?>
								<?php if(Auth::user()->admin->can('paid', $subscription)): ?>
									<li>
										<a
											message="<?php echo e(trans('messages.paid_subscriptions_confirm')); ?>" data-toggle="modal" data-target="#paid-form-modal" href="#paid"
											class="list-form-button"
											data-uids="<?php echo e($subscription->uid); ?>"
											data-method="PATCH"
											data-url="<?php echo e(action('Admin\SubscriptionController@paid')); ?>"
										>
											<i class="icon-checkmark-circle"></i> <?php echo e(trans('messages.paid')); ?>

										</a>
									</li>
								<?php endif; ?>
								<?php if(Auth::user()->admin->can('unpaid', $subscription)): ?>
									<li>
										<a
											message="<?php echo e(trans('messages.unpaid_subscriptions_confirm')); ?>" data-toggle="modal" data-target="#list-form-modal" href="#paid"
											class="list-form-button"
											data-uids="<?php echo e($subscription->uid); ?>"
											data-method="PATCH"
											data-url="<?php echo e(action('Admin\SubscriptionController@unpaid')); ?>"
										>
											<i class="icon-radio-unchecked"></i> <?php echo e(trans('messages.unpaid')); ?>

										</a>
									</li>
								<?php endif; ?>
								<?php if(\Auth::user()->admin->can('delete', $subscription)): ?>
									<li>
										<a data-method='delete' delete-confirm="<?php echo e(trans('messages.delete_subscriptions_confirm')); ?>" href="<?php echo e(action('Admin\SubscriptionController@delete', ['uids' => $subscription->uid])); ?>">
											<i class="icon-trash"></i> <?php echo e(trans('messages.delete')); ?>

										</a>
									</li>
								<?php endif; ?>
							</ul>
						</div>
					<?php endif; ?>
				</td>
			</tr>
		<?php endforeach; ?>
	</table>
	<?php echo $__env->make('elements/_per_page_select', ["items" => $subscriptions], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<?php echo e($subscriptions->links()); ?>

<?php elseif(!empty(request()->keyword) || !empty(request()->filters)): ?>
	<div class="empty-list">
		<i class="icon-quill4"></i>
		<span class="line-1">
			<?php echo e(trans('messages.no_search_result')); ?>

		</span>
	</div>
<?php else: ?>
	<div class="empty-list">
		<i class="icon-quill4"></i>
		<span class="line-1">
			<?php echo e(trans('messages.subscription_empty_line_1_admin')); ?>

		</span>
	</div>
<?php endif; ?>
