<?php if($campaigns->count() > 0): ?>
	<table class="table table-box pml-table"
		current-page="<?php echo e(empty(request()->page) ? 1 : empty(request()->page)); ?>"
	>
		<?php foreach($campaigns as $key => $item): ?>
			<tr>
				<td width="1%">
					<div class="text-nowrap">
						<div class="checkbox inline">
							<label>
								<input type="checkbox" class="node styled"
									custom-order="<?php echo e($item->custom_order); ?>"
									name="ids[]"
									value="<?php echo e($item->uid); ?>"
								/>
							</label>
						</div>
						<?php if(request()->sort_order == 'custom_order' && empty(request()->keyword)): ?>
							<i data-action="move" class="icon icon-more2 list-drag-button"></i>
						<?php endif; ?>
					</div>
				</td>
				<td>
					<h5 class="no-margin text-bold">
						<a class="kq_search" href="<?php echo e(action('CampaignController@show', $item->uid)); ?>">
							<?php echo e($item->name); ?>

						</a>
					</h5>
					<span class="text-muted"><?php echo e(trans('messages.' . $item->type)); ?></span>

					<?php if($item->readCache('SubscriberCount')): ?>
						<div class="text-semibold" data-popup="tooltip" title="<?php echo e($item->displayRecipients()); ?>">
							<?php echo e(number_with_delimiter($item->readCache('SubscriberCount'))); ?> <?php echo e(trans('messages.recipients')); ?>

						</div>
					<?php endif; ?>

					<?php if($item->status != 'new'): ?>
						<span class="text-muted2"><?php echo e(trans('messages.run_at')); ?>: &nbsp;&nbsp;<i class="icon-alarm mr-0"></i> <?php echo e(isset($item->run_at) ? Tool::formatDateTime($item->run_at) : ""); ?></span>
					<?php else: ?>
						<span class="text-muted2"><?php echo e(trans('messages.updated_at')); ?>: <?php echo e(Tool::formatDateTime($item->created_at)); ?></span>
					<?php endif; ?>
				</td>
				<?php if($item->status != 'new'): ?>
					<td class="stat-fix-size-sm">
						<div class="single-stat-box pull-left ml-20">
							<span class="no-margin text-teal-800 stat-num"><?php echo e($item->isSending() ? number_to_percentage($item->deliveredRate(true)) : number_to_percentage($item->readCache('DeliveredRate'))); ?></span>
							<div class="progress progress-xxs">
								<div class="progress-bar progress-bar-info" style="width: <?php echo e($item->isSending() ? number_to_percentage($item->deliveredRate(true)) : number_to_percentage($item->readCache('DeliveredRate'))); ?>">
								</div>
							</div>
							<span class="text-semibold text-nowrap"><?php echo e($item->isSending() ? number_with_delimiter($item->deliveredCount()) : number_with_delimiter($item->readCache('DeliveredCount', 0))); ?> / <?php echo e(number_with_delimiter($item->readCache('SubscriberCount', 0))); ?></span>
							<br />
							<span class="text-muted"><?php echo e(trans('messages.sent')); ?></span>
						</div>
					</td>
					<td class="stat-fix-size-sm">
						<div class="single-stat-box pull-left ml-20">
							<span class="no-margin text-teal-800 stat-num"><?php echo e($item->readCache('UniqOpenRate')); ?>%</span>
							<div class="progress progress-xxs">
								<div class="progress-bar progress-bar-info" style="width: <?php echo e($item->readCache('UniqOpenRate')); ?>%">
								</div>
							</div>
							<span class="text-muted"><?php echo e(trans('messages.open_rate')); ?></span>
						</div>
					</td>
					<td class="stat-fix-size-sm">
						<div class="single-stat-box pull-left ml-20">
							<span class="no-margin text-teal-800 stat-num"><?php echo e($item->readCache('ClickedRate')); ?>%</span>
							<div class="progress progress-xxs">
								<div class="progress-bar progress-bar-info" style="width: <?php echo e($item->readCache('ClickedRate')); ?>%">
								</div>
							</div>
							<span class="text-muted"><?php echo e(trans('messages.click_rate')); ?></span>
						</div>
					</td>
				<?php else: ?>
					<td></td>
					<td></td>
					<td></td>
				<?php endif; ?>
				<td>
					<span class="text-muted2 list-status pull-left" title='<?php echo e($item->status == Acelle\Model\Campaign::STATUS_ERROR ? $item->last_error : ''); ?>' data-popup='tooltip'>
						<span class="label label-flat bg-<?php echo e($item->status); ?>"><?php echo e(trans('messages.campaign_status_' . $item->status)); ?></span>
					</span>
				</td>
				<td class="text-right text-nowrap">
					<?php if(\Gate::allows('update', $item)): ?>
						<a href="<?php echo e(action('CampaignController@edit', $item->uid)); ?>" type="button" class="btn bg-grey btn-icon"> <i class="icon-pencil"></i> <?php echo e(trans('messages.edit')); ?></a>
					<?php endif; ?>
					<?php if(\Gate::allows('overview', $item)): ?>
						<a href="<?php echo e(action('CampaignController@overview', $item->uid)); ?>" data-popup="tooltip" title="<?php echo e(trans('messages.overview')); ?>" type="button" class="btn bg-teal-600 btn-icon"><i class="icon-stats-growth"></i> <?php echo e(trans('messages.overview')); ?></a>
					<?php endif; ?>
					<?php if(\Gate::allows('delete', $item) || \Gate::allows('pause', $item) || \Gate::allows('restart', $item)): ?>
						<div class="btn-group">
							<button type="button" class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret ml-0"></span></button>
							<ul class="dropdown-menu dropdown-menu-right">
								<?php if(\Gate::allows('resend', $item)): ?>
									<li><a data-method='POST' link-confirm="<?php echo e(trans('messages.campaign.resend_confirm')); ?>" href="<?php echo e(action('CampaignController@resend', ["uids" => $item->uid])); ?>">
										<i class="icon-reload-alt"></i> <?php echo e(trans("messages.campaign.resend")); ?></a></li>
								<?php endif; ?>
								<?php if(\Gate::allows('pause', $item)): ?>
									<li><a link-confirm="<?php echo e(trans('messages.pause_campaigns_confirm')); ?>" href="<?php echo e(action('CampaignController@pause', ["uids" => $item->uid])); ?>"><i class="icon-pause"></i> <?php echo e(trans("messages.pause")); ?></a></li>
								<?php endif; ?>
								<?php if(\Gate::allows('restart', $item)): ?>
									<li><a link-confirm="<?php echo e(trans('messages.restart_campaigns_confirm')); ?>" href="<?php echo e(action('CampaignController@restart', ["uids" => $item->uid])); ?>"><i class="icon-history"></i> <?php echo e(trans("messages.restart")); ?></a></li>
								<?php endif; ?>
								<?php if(\Gate::allows('copy', $item)): ?>
									<li>
										<a data-uid="<?php echo e($item->uid); ?>" data-name="<?php echo e(trans("messages.copy_of_campaign", ['name' => $item->name])); ?>" class="copy-campaign-link">
											<i class="icon-copy4"></i> <?php echo e(trans('messages.copy')); ?>

										</a>
									</li>
								<?php endif; ?>
								<?php if(\Gate::allows('delete', $item)): ?>
									<li><a delete-confirm="<?php echo e(trans('messages.delete_campaigns_confirm')); ?>" href="<?php echo e(action('CampaignController@delete', ["uids" => $item->uid])); ?>"><i class="icon-trash"></i> <?php echo e(trans("messages.delete")); ?></a></li>
								<?php endif; ?>
							</ul>
						</div>
					<?php endif; ?>
				</td>
			</tr>
		<?php endforeach; ?>
	</table>
	<?php echo $__env->make('elements/_per_page_select', ["items" => $campaigns], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<?php echo e($campaigns->links()); ?>

<?php elseif(!empty(request()->keyword)): ?>
	<div class="empty-list">
		<i class="icon-paperplane"></i>
		<span class="line-1">
			<?php echo e(trans('messages.no_search_result')); ?>

		</span>
	</div>
<?php else: ?>
	<div class="empty-list">
		<i class="icon-paperplane"></i>
		<span class="line-1">
			<?php echo e(trans('messages.campaign_empty_line_1')); ?>

		</span>
	</div>
<?php endif; ?>
