<?php $__env->startSection('title', $list->name . ": " . trans('messages.segments')); ?>

<?php $__env->startSection('page_script'); ?>
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery_ui/interactions.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery_ui/touch.min.js')); ?>"></script>

	<script type="text/javascript" src="<?php echo e(URL::asset('js/listing.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_header'); ?>

			<?php echo $__env->make("lists._header", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

				<?php echo $__env->make("lists._menu", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

				<h2 class="text-bold text-teal-800 mb-10"><i class="icon-make-group"></i> <?php echo e(trans('messages.segments')); ?></h2>
				<br />
				<form class="listing-form"
					data-url="<?php echo e(action('SegmentController@listing', $list->uid)); ?>"
					per-page="<?php echo e(Acelle\Model\Segment::$itemsPerPage); ?>"
				>
					<div class="row top-list-controls">
						<div class="col-md-10">
							<?php if($list->segmentsCount() >= 0): ?>
								<div class="filter-box">
									<div class="btn-group list_actions hide mr-10">
										<button type="button" class="btn btn-xs btn-grey-600 dropdown-toggle" data-toggle="dropdown">
											<?php echo e(trans('messages.actions')); ?> <span class="caret"></span>
										</button>
										<ul class="dropdown-menu">
											<li>
												<a delete-confirm="<?php echo e(trans('messages.delete_segments_confirm')); ?>" href="<?php echo e(action('SegmentController@delete', $list->uid)); ?>">
													<i class="icon-trash"></i> <?php echo e(trans('messages.delete')); ?>

												</a>
											</li>
										</ul>
									</div>
									<div class="checkbox inline check_all_list">
										<label>
											<input type="checkbox" class="styled check_all">
										</label>
									</div>
									<span class="filter-group">
										<span class="title text-semibold text-muted"><?php echo e(trans('messages.sort_by')); ?></span>
										<select class="select" name="sort-order">
											<option value="segments.name"><?php echo e(trans('messages.name')); ?></option>
											<option value="segments.created_at"><?php echo e(trans('messages.created_at')); ?></option>
											<option value="segments.updated_at"><?php echo e(trans('messages.updated_at')); ?></option>
										</select>
										<button class="btn btn-xs sort-direction" rel="asc" data-popup="tooltip" title="<?php echo e(trans('messages.change_sort_direction')); ?>" type="button" class="btn btn-xs">
											<i class="icon-sort-amount-asc"></i>
										</button>
									</span>
									<span class="text-nowrap">
										<input name="search_keyword" class="form-control search" placeholder="<?php echo e(trans('messages.type_to_search')); ?>" />
										<i class="icon-search4 keyword_search_button"></i>
									</span>
								</div>
							<?php endif; ?>
						</div>
						<div class="col-md-2 text-right">
							<a href="<?php echo e(action("SegmentController@create", $list->uid)); ?>" type="button" class="btn bg-info-800">
								<i class="icon icon-plus2"></i> <?php echo e(trans('messages.create_segment')); ?>

							</a>
						</div>
					</div>

					<div class="pml-table-container">



					</div>

				</form>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>