<!DOCTYPE html>
<html lang="en">
<head>
	<title><?php echo $__env->yieldContent('title'); ?> - Acelle Installation</title>
	
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<?php echo $__env->make('layouts._favicon', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<?php echo $__env->make('layouts._css', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	
	<?php echo $__env->make('layouts._js', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

</head>

<body class="bg-slate-800">

	<!-- Page container -->
	<div class="page-container login-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">
				<div class="row">
					<div class="col-sm-1 col-md-1">
						
					</div>
					<div class="col-sm-10 col-md-10">
					
						<div class="text-center login-header">
							<a class="main-logo-big" href="<?php echo e(action('HomeController@index')); ?>">
								<img src="<?php echo e(URL::asset('images/logo_big.png')); ?>" alt="">
							</a>
                            
                            <h3 class="text-center text-muted2" style="color: #ccc"><?php echo e(trans('messages.installation')); ?></h3>
						</div>
                        
                        <?php echo $__env->make('install._steps', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                        
                        <div class="panel panel-flat" style="border-radius: 0 0 3px 3px">
                            <div class="panel-body">
								<?php if(count($errors) > 0): ?>
									<div class="alert alert-danger alert-noborder">
										<?php foreach($errors->all() as $key => $error): ?>
											<p class="text-semibold"><?php echo e($error); ?></p>
										<?php endforeach; ?>
									</div>
								<?php endif; ?>

                                <?php echo $__env->yieldContent('content'); ?>
                            </div>
						</div>
					</div>
				</div>
			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-white">
			<?php echo trans('messages.copy_right_light'); ?>			
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

</body>
</html>
