<?php $__env->startSection('title', trans('messages.campaigns') . " - " . trans('messages.confirm')); ?>

<?php $__env->startSection('page_script'); ?>
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/plugins/pickers/anytime.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/plugins/forms/styling/uniform.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(URL::asset('js/validate.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_header'); ?>

    <div class="page-title">
        <ul class="breadcrumb breadcrumb-caret position-right">
            <li><a href="<?php echo e(action("HomeController@index")); ?>"><?php echo e(trans('messages.home')); ?></a></li>
            <li><a href="<?php echo e(action("CampaignController@index")); ?>"><?php echo e(trans('messages.campaigns')); ?></a></li>
        </ul>
        <h1>
            <span class="text-semibold"><i class="icon-paperplane"></i> <?php echo e($campaign->name); ?></span>
        </h1>

        <?php echo $__env->make('campaigns._steps', ['current' => 5], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="confirm-campaign-box">
        <form action="<?php echo e(action('CampaignController@confirm', $campaign->uid)); ?>" method="POST" class="form-validate-jqueryz">
            <?php echo e(csrf_field()); ?>


            <div class="head">
                <h2 class="text-semibold mb-5"><?php echo e(trans('messages.you_are_all_send')); ?></h2>
                <p><?php echo e(trans('messages.review_campaign_feeback')); ?></p>
            </div>

            <ul class="modern-listing">
                <li>
                    <a href="<?php echo e(action('CampaignController@recipients', $campaign->uid)); ?>" class="btn btn-info bg-grey"><?php echo e(trans('messages.edit')); ?></a>
                    <!-- <?php echo e($count = $campaign->subscribersCount()); ?> -->
                    <?php if($count): ?>
                        <i class="icon-checkmark4"></i>
                    <?php else: ?>
                        <i class="icon-cross2 text-danger"></i>
                    <?php endif; ?>
                    <h4><?php echo e(number_with_delimiter($count)); ?> <?php echo e(trans('messages.recipients')); ?></h4>
                    <p>
                        <?php echo $campaign->displayRecipients(); ?>

                    </p>
                </li>
                <li>
                    <a href="<?php echo e(action('CampaignController@setup', $campaign->uid)); ?>" class="btn btn-info bg-grey"><?php echo e(trans('messages.edit')); ?></a>
                    <i class="icon-checkmark4"></i>
                    <h4><?php echo e(trans('messages.email_subject')); ?></h4>
                    <p>
                        <?php echo e($campaign->subject); ?>

                    </p>
                </li>
                <li>
                    <a href="<?php echo e(action('CampaignController@setup', $campaign->uid)); ?>" class="btn btn-info bg-grey"><?php echo e(trans('messages.edit')); ?></a>
                    <i class="icon-checkmark4"></i>
                    <h4><?php echo e(trans('messages.reply_to')); ?></h4>
                    <p>
                        <?php echo e($campaign->reply_to); ?>

                    </p>
                </li>
                <li>
                    <a href="<?php echo e(action('CampaignController@setup', $campaign->uid)); ?>" class="btn btn-info bg-grey"><?php echo e(trans('messages.edit')); ?></a>
                    <i class="icon-checkmark4"></i>
                    <h4><?php echo e(trans('messages.tracking')); ?></h4>
                    <p>
                        <?php if($campaign->track_open): ?>
                            <?php echo e(trans('messages.opens')); ?><pp>,</pp>
                        <?php endif; ?>
                        <?php if($campaign->track_click): ?>
                            <?php echo e(trans('messages.clicks')); ?><pp>,</pp>
                        <?php endif; ?>
                    </p>
                </li>
                <li>
                    <a href="<?php echo e(action('CampaignController@schedule', $campaign->uid)); ?>" class="btn btn-info bg-grey"><?php echo e(trans('messages.edit')); ?></a>
                    <i class="icon-checkmark4"></i>
                    <h4><?php echo e(trans('messages.run_at')); ?></h4>
                    <p>
                        <?php echo e(isset($campaign->run_at) ? Acelle\Library\Tool::formatDateTime($campaign->run_at) : ""); ?>

                    </p>
                </li>
            </ul>

            <?php if($campaign->step() >= 5): ?>
                <br />
                <div class="text-right">
                    <span
                        onclick="popupwindow('<?php echo e(action('CampaignController@preview', $campaign->uid)); ?>', '<?php echo e($campaign->name); ?>', 800, 800)"
                        href="#preview" class="btn btn-lg bg-grey mr-5" data-uid="<?php echo e($campaign->uid); ?>">
                        <?php echo e(trans('messages.preview')); ?> <i class="icon-eye"></i>
                    </span>
                    <button class="btn btn-lg bg-grey mr-5 send-a-test-email-link" data-uid="<?php echo e($campaign->uid); ?>"><?php echo e(trans('messages.send_a_test_email')); ?> <i class="icon-envelop3 ml-5"></i> </button>
                    <button class="btn btn-lg bg-teal-800"><?php echo e(trans('messages.send')); ?> <i class="icon-paperplane ml-5"></i> </button>
                </div>
            <?php endif; ?>
        </form>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>