<?php $__env->startSection('title', $list->name . ": " . trans('messages.manage_list_fields') ); ?>

<?php $__env->startSection('page_script'); ?>
    <script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery_ui/interactions.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(URL::asset('assets/js/core/libraries/jquery_ui/touch.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(URL::asset('assets/js/plugins/pickers/anytime.min.js')); ?>"></script>

	<script type="text/javascript" src="<?php echo e(URL::asset('js/listing.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_header'); ?>

			<?php echo $__env->make("lists._header", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

                <?php echo $__env->make("lists._menu", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

                <h2 class="text-bold text-teal-800"><i class="icon-list3"></i> <?php echo e(trans('messages.manage_list_fields')); ?></h2>
                <br />
                <p><?php echo trans('messages.fields_intro'); ?></p>

				<?php if($errors->has("miss_main_field_tag")): ?>
					<div class="text-danger text-semibold">
						<strong><?php echo e($errors->first("miss_main_field_tag")); ?></strong>
					</div>
				<?php endif; ?>
				<?php if($errors->has("conflict_field_tags")): ?>
					<div class="text-danger text-semibold">
						<strong><?php echo e($errors->first("conflict_field_tags")); ?></strong>
					</div>
				<?php endif; ?>

                <form action="<?php echo e(action('FieldController@store', $list->uid)); ?>" class="listing-form"
					sort-urla="<?php echo e(action('FieldController@sort', $list->uid)); ?>"
					per-page="1"
					method="POST"
                >
					<?php echo e(csrf_field()); ?>


                    <?php if($fields->count() > 0): ?>
                        <table class="table table-box table-box-head field-list"
                            current-page="1"
                        >
								<th width="1%"></th>
                                <th><?php echo e(trans('messages.field_label_and_type')); ?></th>
                                <th><?php echo e(trans('messages.required?')); ?></th>
                                <th><?php echo e(trans('messages.visible?')); ?></th>
                                <th><?php echo e(trans('messages.tag')); ?></th>
                                <th><?php echo e(trans('messages.default_value')); ?></th>
								<th></th>
                            <?php foreach($fields as $key => $item): ?>
                                <tr class="draggable" rel="<?php echo e($item->uid); ?>">
									<td>
										<input type="hidden" class="custom_order"
                                            value="<?php echo e($item->custom_order); ?>"
											name="fields[<?php echo e($item->uid); ?>][custom_order]"
                                        />
										<input type="hidden" class="node"
                                            custom-order="<?php echo e($item->custom_order); ?>"
                                            value="<?php echo e($item->uid); ?>"
											name="fields[<?php echo e($item->uid); ?>][uid]"
                                        />
										<i data-action="move" class="icon icon-more2 list-drag-button"></i>
									</td>
                                    <td class="text-nowrap">
                                        <?php echo $__env->make('helpers.form_control', ['type' => 'text', 'name' => 'fields[' . $item->uid . '][label]', 'label' => '', 'subfix' => trans('messages.' . $item->type), 'value' => $item->label, 'help_class' => 'field'], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
										<input type="hidden"
                                            value="<?php echo e($item->type); ?>"
											name="fields[<?php echo e($item->uid); ?>][type]"
                                        />
                                    </td>
                                    <td class="text-nowrap">
										<?php echo $__env->make('helpers.form_control', ['disabled' => $item->tag == 'EMAIL', 'type' => 'checkbox', 'name' => 'fields[' . $item->uid . '][required]', 'label' => '', 'value' => $item->required, 'options' => [false,true], 'help_class' => 'field'], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
									</td>
                                    <td class="text-nowrap">
										<?php echo $__env->make('helpers.form_control', ['disabled' => $item->tag == 'EMAIL', 'type' => 'checkbox', 'name' => 'fields[' . $item->uid . '][visible]', 'label' => '', 'value' => $item->visible, 'options' => [false,true], 'help_class' => 'field'], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
									</td>
                                    <td class="text-nowrap">
										<?php echo $__env->make('helpers.form_control', ['disabled' => $item->tag == 'EMAIL', 'type' => 'text', 'name' => 'fields[' . $item->uid . '][tag]', 'label' => '', 'value' => $item->tag, 'help_class' => 'field', 'prefix' => "[", 'subfix' => "]"], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
									</td>
                                    <td class="text-nowrap">
										<?php echo $__env->make('helpers.form_control', ['type' => Acelle\Model\Field::getControlNameByType($item->type), 'name' => 'fields[' . $item->uid . '][default_value]', 'label' => '', 'value' => $item->default_value, 'help_class' => 'field'], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
									</td>
									<td>
										<?php if($item->tag != 'EMAIL'): ?>
											<?php if(is_object(Acelle\Model\Field::findByUid($item->uid))): ?>
												<a no-ajax="true" href="<?php echo e(action('FieldController@delete', ['list_uid' => $list->uid, 'uid' => $item->uid])); ?>" delete-confirm="<?php echo trans('messages.delete_field_alert'); ?>" class="btn bg-danger-400 remove-field-button">
													<i class="icon-trash"></i>
												</a>
											<?php else: ?>
												<a href="#delete" class="btn bg-danger-400 remove-not-saved-field"><i class="icon-trash"></i></a>
											<?php endif; ?>
										<?php endif; ?>
									</td>
                                </tr>

								<?php if(count($item->fieldOptions)): ?>
									<tr class="child" parent="<?php echo e($item->uid); ?>">
										<td></td>
										<td colspan="5" class="sub_field_options">
											<div class="row">
												<div class="col-md-12">
													<div class="row label-value-groups">
														<?php foreach($item->fieldOptions as $key => $option): ?>
															<div class="col-md-6 text-nowrap label-value-group" rel="<?php echo e($option->uid); ?>">
																<div class="pull-left mr-10"><?php echo $__env->make('helpers.form_control', ['type' => 'text', 'placeholder' => trans('messages.label'), 'name' => 'fields[' . $item->uid . '][options][' . $option->uid . '][label]', 'label' => '', 'value' => $option->label, 'help_class' => 'field'], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?></div>
																<div class="pull-left mr-10"><?php echo $__env->make('helpers.form_control', ['type' => 'text', 'placeholder' => trans('messages.value'), 'name' => 'fields[' . $item->uid . '][options][' . $option->uid . '][value]', 'label' => '', 'value' => $option->value, 'help_class' => 'field'], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?></div>
																<div class="pull-left"><a href="#remove" onclick="$(this).parents('.label-value-group').remove()" class="btn btn-xs bg-grey-600"><i class="icon-cross"></i></a></div>
															</div>
														<?php endforeach; ?>
													</div>
												</div>
											</div>
										</td>
										<td>
											<a href="#add_more" class="btn bg-teal add_label_value_group"><?php echo e(trans('messages.add_more')); ?></a>
										</td>
									</tr>
								<?php endif; ?>
                            <?php endforeach; ?>
                        </table>
                    <?php endif; ?>
					<br />
					<h4><?php echo e(trans('messages.add_field')); ?></h4>
					<div>
						<span sample-url="<?php echo e(action("FieldController@sample", ['list_uid' => $list->uid, "type" => "text"])); ?>" class="btn btn-default btn-xs add-custom-field-button mr-10" type_name="text">
							<i class="icon-font-size2"></i> <?php echo e(trans('messages.text_field')); ?>

						</span>
						<span sample-url="<?php echo e(action("FieldController@sample", ['list_uid' => $list->uid, "type" => "number"])); ?>" class="btn btn-default btn-xs add-custom-field-button mr-10" type_name="number">
							<i class="icon-sort-numeric-asc"></i> <?php echo e(trans('messages.number_field')); ?>

						</span>
						<span sample-url="<?php echo e(action("FieldController@sample", ['list_uid' => $list->uid, "type" => "dropdown"])); ?>" class="btn btn-default btn-xs add-custom-field-button mr-10" type_name="dropdown">
							<i class="icon-menu2"></i> <?php echo e(trans('messages.dropdown_field')); ?>

						</span>
						<span sample-url="<?php echo e(action("FieldController@sample", ['list_uid' => $list->uid, "type" => "multiselect"])); ?>" class="btn btn-default btn-xs add-custom-field-button mr-10" type_name="multiselect"><i class="icon-menu3"></i> <?php echo e(trans('messages.multiselect_field')); ?></span>
						<span sample-url="<?php echo e(action("FieldController@sample", ['list_uid' => $list->uid, "type" => "checkbox"])); ?>" class="btn btn-default btn-xs add-custom-field-button mr-10" type_name="checkbox"><i class="icon-checkbox-partial2"></i> <?php echo e(trans('messages.checkbox_field')); ?></span>
						<span sample-url="<?php echo e(action("FieldController@sample", ['list_uid' => $list->uid, "type" => "radio"])); ?>" class="btn btn-default btn-xs add-custom-field-button mr-10" type_name="radio"><i class="icon-circles"></i> <?php echo e(trans('messages.radio_field')); ?></span>
						<span sample-url="<?php echo e(action("FieldController@sample", ['list_uid' => $list->uid, "type" => "date"])); ?>" class="btn btn-default btn-xs add-custom-field-button mr-10" type_name="date"><i class="icon-calendar52"></i> <?php echo e(trans('messages.date_field')); ?></span>
						<span sample-url="<?php echo e(action("FieldController@sample", ['list_uid' => $list->uid, "type" => "datetime"])); ?>" class="btn btn-default btn-xs add-custom-field-button mr-10" type_name="datetime"><i class="icon-alarm"></i> <?php echo e(trans('messages.datetime_field')); ?></span>
						<span sample-url="<?php echo e(action("FieldController@sample", ['list_uid' => $list->uid, "type" => "textarea"])); ?>" class="btn btn-default btn-xs add-custom-field-button" type_name="textarea"><i class="icon-menu6"></i> <?php echo e(trans('messages.textarea_field')); ?></span>
					</div>

					<hr /><br />
					<div class="">
						<button class="btn bg-teal mr-10"><i class="icon-check"></i> <?php echo e(trans('messages.save_change')); ?></button>
					</div>
                </form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>